/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmAssociation;
import org.apache.olingo.odata2.api.edm.EdmComplexType;
import org.apache.olingo.odata2.api.edm.EdmEntityContainer;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.AliasInfo;
import org.apache.olingo.odata2.api.edm.provider.Association;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.edm.provider.EdmProviderAccessor;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.FunctionImport;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.core.edm.EdmImpl;
import org.apache.olingo.odata2.core.edm.provider.EdmAssociationImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmComplexTypeImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmEntityContainerImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmEntitySetImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmEntityTypeImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmFunctionImportImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmServiceMetadataImplProv;

public class EdmImplProv
extends EdmImpl
implements EdmProviderAccessor {
    protected EdmProvider edmProvider;
    private List<Schema> schemas;

    public EdmImplProv(EdmProvider edmProvider) {
        super(new EdmServiceMetadataImplProv(edmProvider));
        this.edmProvider = edmProvider;
    }

    @Override
    protected EdmEntityContainer createEntityContainer(String name) throws ODataException {
        EntityContainerInfo enitityContainerInfo = this.edmProvider.getEntityContainerInfo(name);
        if (enitityContainerInfo == null) {
            return null;
        }
        return new EdmEntityContainerImplProv(this, enitityContainerInfo);
    }

    @Override
    protected EdmEntityType createEntityType(FullQualifiedName fqName) throws ODataException {
        EntityType entityType = this.edmProvider.getEntityType(fqName);
        if (entityType == null) {
            return null;
        }
        return new EdmEntityTypeImplProv(this, entityType, fqName.getNamespace());
    }

    @Override
    protected EdmComplexType createComplexType(FullQualifiedName fqName) throws ODataException {
        ComplexType complexType = this.edmProvider.getComplexType(fqName);
        if (complexType == null) {
            return null;
        }
        return new EdmComplexTypeImplProv(this, complexType, fqName.getNamespace());
    }

    @Override
    protected EdmAssociation createAssociation(FullQualifiedName fqName) throws ODataException {
        Association association = this.edmProvider.getAssociation(fqName);
        if (association == null) {
            return null;
        }
        return new EdmAssociationImplProv(this, association, fqName.getNamespace());
    }

    public EdmProvider getEdmProvider() {
        return this.edmProvider;
    }

    @Override
    protected List<EdmEntitySet> createEntitySets() throws ODataException {
        ArrayList<EdmEntitySet> edmEntitySets = new ArrayList<EdmEntitySet>();
        if (this.schemas == null) {
            this.schemas = this.edmProvider.getSchemas();
        }
        for (Schema schema : this.schemas) {
            for (EntityContainer entityContainer : schema.getEntityContainers()) {
                for (EntitySet entitySet : entityContainer.getEntitySets()) {
                    EdmEntityContainer edmEntityContainer = this.createEntityContainer(entityContainer.getName());
                    edmEntitySets.add(new EdmEntitySetImplProv(this, entitySet, edmEntityContainer));
                }
            }
        }
        return edmEntitySets;
    }

    @Override
    protected List<EdmFunctionImport> createFunctionImports() throws ODataException {
        ArrayList<EdmFunctionImport> edmFunctionImports = new ArrayList<EdmFunctionImport>();
        if (this.schemas == null) {
            this.schemas = this.edmProvider.getSchemas();
        }
        for (Schema schema : this.schemas) {
            for (EntityContainer entityContainer : schema.getEntityContainers()) {
                for (FunctionImport functionImport : entityContainer.getFunctionImports()) {
                    EdmEntityContainer edmEntityContainer = this.createEntityContainer(entityContainer.getName());
                    edmFunctionImports.add(new EdmFunctionImportImplProv(this, functionImport, edmEntityContainer));
                }
            }
        }
        return edmFunctionImports;
    }

    @Override
    protected Map<String, String> createAliasToNamespaceInfo() throws ODataException {
        List aliasInfos = this.edmProvider.getAliasInfos();
        HashMap<String, String> aliasToNamespaceInfo = new HashMap<String, String>();
        if (aliasInfos != null) {
            for (AliasInfo info : aliasInfos) {
                aliasToNamespaceInfo.put(info.getAlias(), info.getNamespace());
            }
        }
        return aliasToNamespaceInfo;
    }
}

