/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.util.MathUtils;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.VirtualThreads;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.thread.ThreadIdPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.ThreadPoolBudget;
import org.eclipse.jetty.util.thread.TryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="A pool for reserved threads")
public class ReservedThreadExecutor
extends ContainerLifeCycle
implements TryExecutor,
Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(ReservedThreadExecutor.class);
    private final Executor _executor;
    private final ThreadIdPool<ReservedThread> _threads;
    private final AtomicInteger _pending = new AtomicInteger();
    private final int _minSize;
    private final int _maxPending;
    private ThreadPoolBudget.Lease _lease;
    private long _idleTimeoutMs;

    public ReservedThreadExecutor(Executor executor, int capacity) {
        this(executor, capacity, -1);
    }

    public ReservedThreadExecutor(Executor executor, int capacity, int minSize) {
        this(executor, capacity, minSize, 0);
    }

    public ReservedThreadExecutor(Executor executor, int capacity, int minSize, int maxPending) {
        this._executor = executor;
        this._threads = new ThreadIdPool(ReservedThreadExecutor.reservedThreads(executor, capacity));
        int n = this._minSize = minSize < 0 ? Math.min(1, this._threads.capacity()) : minSize;
        if (this._minSize > this._threads.capacity()) {
            throw new IllegalArgumentException("minSize larger than capacity");
        }
        this._maxPending = maxPending < 0 ? -1 : (maxPending == 0 ? this._threads.capacity() : maxPending);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)this);
        }
        this.installBean(this._executor);
        this.installBean(this._threads);
    }

    public static int reservedThreads(Executor executor, int capacity) {
        if (capacity >= 0) {
            return capacity;
        }
        if (VirtualThreads.isUseVirtualThreads(executor)) {
            return 0;
        }
        int cpus = ProcessorUtils.availableProcessors();
        if (executor instanceof ThreadPool.SizedThreadPool) {
            int threads = ((ThreadPool.SizedThreadPool)executor).getMaxThreads();
            return Math.max(1, MathUtils.ceilToNextPowerOfTwo(Math.min(cpus, threads / 8)));
        }
        return cpus;
    }

    public Executor getExecutor() {
        return this._executor;
    }

    @ManagedAttribute(value="max number of reserved threads", readonly=true)
    public int getCapacity() {
        return this._threads.capacity();
    }

    @ManagedAttribute(value="available reserved threads", readonly=true)
    public int getAvailable() {
        return this._threads.size();
    }

    @ManagedAttribute(value="pending reserved threads (deprecated)", readonly=true)
    @Deprecated
    public int getPending() {
        return 0;
    }

    @ManagedAttribute(value="idle timeout in ms", readonly=true)
    public long getIdleTimeoutMs() {
        return this._idleTimeoutMs;
    }

    public void setIdleTimeout(long idleTime, TimeUnit idleTimeUnit) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._idleTimeoutMs = idleTime <= 0L ? 0L : idleTimeUnit.toMillis(idleTime);
    }

    @Override
    public void doStart() throws Exception {
        this._lease = ThreadPoolBudget.leaseFrom(this.getExecutor(), this, this.getCapacity());
        super.doStart();
    }

    @Override
    public void doStop() throws Exception {
        if (this._lease != null) {
            this._lease.close();
        }
        super.doStop();
        this._threads.removeAll().forEach(ReservedThread::stop);
    }

    @Override
    public void execute(Runnable task) throws RejectedExecutionException {
        this._executor.execute(task);
    }

    @Override
    public boolean tryExecute(Runnable task) {
        if (task == null) {
            return false;
        }
        ReservedThread reserved = this._threads.take();
        if (reserved != null) {
            reserved.wakeup(task);
            return true;
        }
        this.startReservedThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} tryExecute failed for {}", (Object)this, (Object)task);
        }
        return false;
    }

    private void startReservedThread() {
        block3: {
            if (this._maxPending > 0 && this._pending.incrementAndGet() > this._maxPending) {
                this._pending.decrementAndGet();
                return;
            }
            try {
                ReservedThread thread = new ReservedThread();
                this._executor.execute(thread);
            }
            catch (Throwable e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("ignored", e);
            }
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, new Object[0]);
    }

    @Override
    public String toString() {
        return String.format("%s@%x{capacity=%d,threads=%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getCapacity(), this._threads);
    }

    private class ReservedThread
    implements Runnable {
        private final Semaphore _semaphore = new Semaphore(0);
        private volatile Runnable _task;
        private volatile Thread _thread;

        private ReservedThread() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[WHILELOOP]], but top level block is 5[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void wakeup(Runnable task) {
            this._task = task;
            this._semaphore.release();
        }

        private Runnable waitForTask() {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("waiting for task");
                }
                if (ReservedThreadExecutor.this._idleTimeoutMs <= 0L) {
                    this._semaphore.acquire();
                } else if (!this._semaphore.tryAcquire(ReservedThreadExecutor.this._idleTimeoutMs, TimeUnit.MILLISECONDS)) {
                    return null;
                }
                Runnable task = this._task;
                this._task = null;
                return task;
            }
            catch (Throwable e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("wait failed ", e);
                }
                return null;
            }
        }

        private void stop() {
            this._semaphore.release();
            Thread thread = this._thread;
            if (thread != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("interrupting thread {} for stop", (Object)thread);
                }
                thread.interrupt();
            }
        }

        public String toString() {
            return String.format("%s@%x{thread=%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this._thread);
        }
    }
}

