/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.NarCoordinateDTO;
import org.apache.nifi.web.api.dto.NarSummaryDTO;
import org.apache.nifi.web.api.entity.NarSummariesEntity;
import org.apache.nifi.web.api.entity.NarSummaryEntity;

public class NarSummariesEntityResult
extends AbstractWritableResult<NarSummariesEntity> {
    private final NarSummariesEntity summariesEntity;

    public NarSummariesEntityResult(ResultType resultType, NarSummariesEntity summariesEntity) {
        super(resultType);
        this.summariesEntity = summariesEntity;
    }

    @Override
    public NarSummariesEntity getResult() {
        return this.summariesEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Collection summaries = this.summariesEntity.getNarSummaries();
        if (summaries == null || summaries.isEmpty()) {
            return;
        }
        Table table = new Table.Builder().column("#", 3, 3, false).column("Id", 36, 36, false).column("Group", 20, 36, false).column("Artifact", 36, 36, false).column("Version", 6, 20, false).column("State", 6, 20, false).build();
        int count = 0;
        for (NarSummaryEntity summary : summaries) {
            NarSummaryDTO summaryDTO = summary.getNarSummary();
            NarCoordinateDTO coordinateDTO = summaryDTO.getCoordinate();
            String identifier = summaryDTO.getIdentifier();
            table.addRow("" + ++count, identifier, coordinateDTO.getGroup(), coordinateDTO.getArtifact(), coordinateDTO.getVersion(), summaryDTO.getState());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

