/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelPopup;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.GoLinkRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class PanelPopupRenderer
extends XhtmlRenderer {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PanelPopupRenderer.class);
    private PropertyKey _textKey;
    private PropertyKey _titleKey;
    private PropertyKey _triggerTypeKey;
    private PropertyKey _positionKey;
    private PropertyKey _modalKey;
    private PropertyKey _contentStyleKey;
    private PropertyKey _widthKey;
    private PropertyKey _heightKey;
    private PropertyKey _horzOffsetKey;
    private PropertyKey _vertOffsetKey;
    private XhtmlRenderer _triggerRenderer;
    private PropertyKey _iconKey;
    private static final String _POPUP_CONTAINER_ID_SUFFIX = "_popupContainer";
    private static final String _POPUP_TRIGGER_ID_SUFFIX = "_popupTrigger";
    private static final String _POPUP_CONTAINER_DIV_STYLES = "position:absolute; top:0px; left:0px; visibility:hidden;";

    public PanelPopupRenderer() {
        this(CorePanelPopup.TYPE);
    }

    protected PanelPopupRenderer(FacesBean.Type type) {
        super(type);
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._textKey = type.findKey("text");
        this._iconKey = type.findKey("icon");
        this._titleKey = type.findKey("title");
        this._triggerTypeKey = type.findKey("triggerType");
        this._positionKey = type.findKey("position");
        this._modalKey = type.findKey("modal");
        this._contentStyleKey = type.findKey("contentStyle");
        this._widthKey = type.findKey("width");
        this._heightKey = type.findKey("height");
        this._horzOffsetKey = type.findKey("xoffset");
        this._vertOffsetKey = type.findKey("yoffset");
        this._triggerRenderer = new TriggerRenderer();
    }

    protected String getText(UIComponent component, FacesBean bean) {
        return PanelPopupRenderer.toString((Object)this.resolveProperty(bean, this._textKey));
    }

    protected String getIcon(UIComponent component, FacesBean bean) {
        return PanelPopupRenderer.toResourceUri((FacesContext)FacesContext.getCurrentInstance(), (Object)this.resolveProperty(bean, this._iconKey));
    }

    protected String getTitle(UIComponent component, FacesBean bean) {
        return PanelPopupRenderer.toString((Object)this.resolveProperty(bean, this._titleKey));
    }

    protected String getTriggerType(UIComponent component, FacesBean bean) {
        return PanelPopupRenderer.toString((Object)this.resolveProperty(bean, this._triggerTypeKey, true));
    }

    protected String getPosition(UIComponent component, FacesBean bean) {
        return PanelPopupRenderer.toString((Object)this.resolveProperty(bean, this._positionKey));
    }

    protected String getContentStyle(UIComponent component, FacesBean bean) {
        return PanelPopupRenderer.toString((Object)this.resolveProperty(bean, this._contentStyleKey));
    }

    protected int getWidth(UIComponent component, FacesBean bean) {
        return PanelPopupRenderer.toInt((Object)this.resolveProperty(bean, this._widthKey, true));
    }

    protected int getHeight(UIComponent component, FacesBean bean) {
        return PanelPopupRenderer.toInt((Object)this.resolveProperty(bean, this._heightKey, true));
    }

    protected int getHorzOffset(UIComponent component, FacesBean bean) {
        return PanelPopupRenderer.toInt((Object)this.resolveProperty(bean, this._horzOffsetKey, true));
    }

    protected int getVertOffset(UIComponent component, FacesBean bean) {
        return PanelPopupRenderer.toInt((Object)this.resolveProperty(bean, this._vertOffsetKey, true));
    }

    protected boolean isModal(UIComponent component, FacesBean bean) {
        return (Boolean)this.resolveProperty(bean, this._modalKey, true);
    }

    protected boolean isCentered(UIComponent component, FacesBean bean) {
        String centeredString = PanelPopupRenderer.toString((Object)this.resolveProperty(bean, this._positionKey));
        return "centered".equalsIgnoreCase(centeredString);
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (!PanelPopupRenderer.supportsScripting(rc)) {
            this.renderTrigger(context, rc, component, bean);
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = this.getClientId(context, component);
        assert (rc.getCurrentClientId() == null);
        rc.setCurrentClientId(clientId);
        writer.startElement("span", component);
        writer.writeAttribute("id_popupTrigger", (Object)XhtmlUtils.getJSIdentifier(clientId), null);
        PanelPopupRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|panelPopup::trigger");
        this.renderTrigger(context, rc, component, bean);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(XhtmlUtils.getJSIdentifier(clientId) + _POPUP_CONTAINER_ID_SUFFIX), null);
        writer.writeAttribute("style", (Object)_POPUP_CONTAINER_DIV_STYLES, null);
        writer.startElement("div", null);
        PanelPopupRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|panelPopup::container");
        this.renderInlineStyle(context, rc, component, bean);
        this.renderTitleBar(context, rc, component, bean);
        writer.startElement("div", null);
        PanelPopupRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|panelPopup::content");
        int height = this.getHeight(component, bean);
        if (height > 0) {
            String style = "overflow: auto; height:" + height + "px";
            writer.writeAttribute("style", (Object)style, null);
        }
        rc.setCurrentClientId(null);
        this.encodeAllChildren(context, component);
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("span");
    }

    protected void renderTrigger(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        this.delegateRendererBegin(context, rc, component, bean, this._triggerRenderer);
        UIComponent triggerFacet = PanelPopupRenderer.getFacet((UIComponent)component, (String)"trigger");
        if (triggerFacet != null) {
            String savedClientId = rc.getCurrentClientId();
            rc.setCurrentClientId(null);
            this.encodeChild(context, triggerFacet);
            rc.setCurrentClientId(savedClientId);
        }
        OutputUtils.renderImage(context, rc, this.getIcon(component, bean), null, null, null, "", component, null, "af|panelPopup::icon-style");
        this.delegateRendererEnd(context, rc, component, bean, this._triggerRenderer);
    }

    protected void renderTitleBar(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String title = this.getTitle(component, bean);
        if (title == null) {
            return;
        }
        writer.startElement("div", null);
        PanelPopupRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|panelPopup::title-bar");
        writer.startElement("div", null);
        PanelPopupRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|panelPopup::title-text");
        writer.writeAttribute("style", (Object)"float:left;", null);
        writer.writeText((Object)title, "title");
        writer.endElement("div");
        Icon icon = rc.getIcon("af|panelPopup::close-icon");
        if (this.isModal(component, bean)) {
            writer.startElement("div", null);
            PanelPopupRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|panelPopup::close-icon");
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("onclick", (Object)"TrPanelPopup.hidePopup(event); return false;", null);
            if (icon != null && !icon.isNull()) {
                String closeText = rc.getTranslatedString("af_panelPopup.CLOSE");
                OutputUtils.renderIcon(context, rc, icon, closeText, null);
            } else {
                writer.writeText((Object)"X", "text");
            }
            writer.endElement("a");
            writer.endElement("div");
        }
        writer.startElement("div", null);
        writer.writeAttribute("style", (Object)"clear: left;", null);
        writer.endElement("div");
        writer.endElement("div");
    }

    private class TriggerRenderer
    extends GoLinkRenderer {
        private TriggerRenderer() {
        }

        @Override
        protected boolean shouldRenderId(FacesContext context, UIComponent component) {
            return true;
        }

        protected String getClientId(FacesContext context, UIComponent component) {
            return XhtmlUtils.getJSIdentifier(PanelPopupRenderer.this.getClientId(context, component));
        }

        @Override
        protected String getOnclick(UIComponent component, FacesBean bean) {
            String onclick = PanelPopupRenderer.this.getOnclick(component, bean);
            String script = null;
            if ("click".equalsIgnoreCase(PanelPopupRenderer.this.getTriggerType(component, bean))) {
                String componentId = RenderingContext.getCurrentInstance().getCurrentClientId();
                script = this.getTriggerScript(component, bean, componentId);
            }
            return XhtmlUtils.getChainedJS(onclick, script, true);
        }

        @Override
        protected String getOnmouseover(UIComponent component, FacesBean bean) {
            String onclick = super.getOnmouseover(component, bean);
            String script = null;
            if ("hover".equalsIgnoreCase(PanelPopupRenderer.this.getTriggerType(component, bean))) {
                String componentId = RenderingContext.getCurrentInstance().getCurrentClientId();
                script = this.getTriggerScript(component, bean, componentId);
            }
            return XhtmlUtils.getChainedJS(onclick, script, true);
        }

        @Override
        protected String getText(UIComponent component, FacesBean bean) {
            return PanelPopupRenderer.this.getText(component, bean);
        }

        @Override
        protected String getInlineStyle(UIComponent component, FacesBean bean) {
            return PanelPopupRenderer.this.getInlineStyle(component, bean);
        }

        @Override
        protected String getStyleClass(UIComponent component, FacesBean bean) {
            return PanelPopupRenderer.this.getStyleClass(component, bean);
        }

        @Override
        protected String getDefaultStyleClass(UIComponent component, FacesBean bean) {
            return "af|panelPopup::link";
        }

        protected String getTriggerScript(UIComponent component, FacesBean bean, String componentId) {
            String clientId = XhtmlUtils.getJSIdentifier(componentId);
            StringBuilder script = new StringBuilder();
            script.append("TrPanelPopup.showPopup('");
            script.append(clientId);
            script.append(PanelPopupRenderer._POPUP_CONTAINER_ID_SUFFIX);
            script.append("', '");
            script.append(clientId);
            script.append("', event, '");
            script.append(PanelPopupRenderer.this.getTriggerType(component, bean));
            script.append("','");
            script.append(PanelPopupRenderer.this.getPosition(component, bean));
            script.append("',");
            script.append(PanelPopupRenderer.this.isModal(component, bean));
            script.append(",");
            script.append(PanelPopupRenderer.this.getWidth(component, bean));
            script.append(",");
            script.append(PanelPopupRenderer.this.getHeight(component, bean));
            script.append(",");
            script.append(PanelPopupRenderer.this.getHorzOffset(component, bean));
            script.append(",");
            script.append(PanelPopupRenderer.this.getVertOffset(component, bean));
            script.append("); return false;");
            return script.toString();
        }
    }
}

