/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.io;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.io.HTMLEscapes;
import org.apache.myfaces.trinidadinternal.share.url.EncoderUtils;
import org.apache.myfaces.trinidadinternal.share.util.CaboHttpUtils;

public class HtmlResponseWriter
extends ResponseWriter {
    public static final String HTML_CONTENT_TYPE = "text/html";
    private static String[][] _emptyElementArr = new String[256][];
    private static String[] _aNames = new String[]{"area"};
    private static String[] _bNames = new String[]{"br", "base", "basefont"};
    private static String[] _cNames = new String[]{"col"};
    private static String[] _eNames = new String[]{"embed"};
    private static String[] _fNames = new String[]{"frame"};
    private static String[] _hNames = new String[]{"hr"};
    private static String[] _iNames = new String[]{"img", "input", "isindex"};
    private static String[] _lNames = new String[]{"link"};
    private static String[] _mNames = new String[]{"meta"};
    private static String[] _pNames = new String[]{"param"};
    private char[] _buffer = new char[1028];
    private boolean _closeStart;
    private boolean _dontEscape;
    private Writer _out;
    private String _encoding;
    private String _pendingElement;
    private String _currAttr;
    private int _cdataCount;
    private Map<String, Object> _passThroughAttributes;
    private final ArrayList<String> _skippedElements = new ArrayList(20);
    private static final Class<?> _CHAR_ARRAY_CLASS;
    private static final Class<?> _BOOLEAN_CLASS;
    private static final Class<?> _INTEGER_CLASS;
    private static final TrinidadLogger _LOG;

    public HtmlResponseWriter(Writer out, String encoding) throws UnsupportedEncodingException {
        this._out = out;
        this._encoding = encoding;
        this._cdataCount = 0;
        CaboHttpUtils.validateEncoding(encoding);
    }

    public String getCharacterEncoding() {
        return this._encoding;
    }

    public String getContentType() {
        return HTML_CONTENT_TYPE;
    }

    public void startDocument() throws IOException {
    }

    public void startCDATA() throws IOException {
        this._closeStartIfNecessary();
        ++this._cdataCount;
        if (this._cdataCount == 1) {
            this._out.write("<![CDATA[");
        }
    }

    public void endCDATA() throws IOException {
        if (this._cdataCount == 1) {
            this._out.write("]]>");
        }
        --this._cdataCount;
    }

    public void endDocument() throws IOException {
        this._out.flush();
    }

    public void flush() throws IOException {
        this._closeStartIfNecessary();
        this._out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this._out.close();
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if ((name = this._processPassThroughAttributes(name, component)).charAt(0) == 's') {
            if ("span".equals(name)) {
                this._markPendingElements();
                this._pendingElement = name;
                return;
            }
            if ("script".equals(name) || "style".equals(name)) {
                this._dontEscape = true;
            }
        }
        this._startElementImpl(name);
    }

    private String _processPassThroughAttributes(String name, UIComponent component) {
        if (component == null) {
            return name;
        }
        this._passThroughAttributes = component.getPassThroughAttributes(false);
        if (this._passThroughAttributes != null) {
            String elementName;
            Object value = this._passThroughAttributes.get("elementName");
            if (value instanceof ValueExpression) {
                value = ((ValueExpression)value).getValue(FacesContext.getCurrentInstance().getELContext());
            }
            if (value != null && !name.equals(elementName = value.toString())) {
                name = elementName;
            }
        }
        return name;
    }

    public void endElement(String name) throws IOException {
        if (this._pendingElement != null) {
            this._pendingElement = null;
            return;
        }
        String element = this._popSkippedElement();
        if (element != null) {
            Writer out = this._out;
            this._dontEscape = false;
            if (this._closeStart) {
                boolean isEmptyElement = HtmlResponseWriter._isEmptyElement(element);
                if (this._currAttr != null) {
                    out.write(34);
                    this._currAttr = null;
                }
                out.write(62);
                this._closeStart = false;
                if (isEmptyElement) {
                    return;
                }
            }
            out.write("</");
            out.write(element);
            out.write(62);
        }
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (value == null) {
            return;
        }
        this._outputPendingElements();
        if (!this._closeStart) {
            throw new IllegalStateException();
        }
        Writer out = this._out;
        Class<?> valueClass = value.getClass();
        String currAttr = this._currAttr;
        if (currAttr != null) {
            if (currAttr.equals(name)) {
                this._writeValue(valueClass, value, true);
                return;
            }
            out.write(34);
        }
        if (valueClass == _BOOLEAN_CLASS) {
            if (Boolean.TRUE.equals(value)) {
                out.write(32);
                out.write(name);
            }
            this._currAttr = null;
        } else {
            out.write(32);
            out.write(name);
            out.write("=\"");
            this._writeValue(valueClass, value, true);
            this._currAttr = name;
        }
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (value == null) {
            return;
        }
        this._outputPendingElements();
        if (!this._closeStart) {
            throw new IllegalStateException();
        }
        Writer out = this._out;
        String currAttr = this._currAttr;
        if (currAttr != null) {
            out.write(34);
            this._currAttr = null;
        }
        out.write(32);
        out.write(name);
        out.write("=\"");
        String stringValue = value.toString();
        if (stringValue.startsWith("javascript:")) {
            HTMLEscapes.writeAttribute(out, this._buffer, stringValue);
        } else {
            EncoderUtils.writeURLForHTML(out, stringValue, this._encoding, false);
        }
        out.write(34);
    }

    public void writeComment(Object comment) throws IOException {
        if (comment != null) {
            this._closeStartIfNecessary();
            this._out.write("<!--");
            this._out.write(comment.toString());
            this._out.write("-->");
        }
    }

    public void writeText(Object text, String componentPropertyName) throws IOException {
        if (text != null) {
            if (this._dontEscape) {
                this.write(text.toString());
            } else {
                this._closeStartIfNecessary();
                HTMLEscapes.writeText(this._out, this._buffer, text.toString());
            }
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (this._dontEscape) {
            this.write(text, off, len);
        } else {
            this._closeStartIfNecessary();
            HTMLEscapes.writeText(this._out, this._buffer, text, off, len);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this._closeStartIfNecessary();
        this._out.write(cbuf, off, len);
    }

    public void write(String str) throws IOException {
        this._closeStartIfNecessary();
        this._out.write(str);
    }

    public void write(int c) throws IOException {
        this._closeStartIfNecessary();
        this._out.write((char)c);
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        try {
            return new HtmlResponseWriter(writer, this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            throw new IllegalStateException();
        }
    }

    public String toString() {
        return "HtmlResponseWriter[" + this._out + "]";
    }

    private void _startElementImpl(String name) throws IOException {
        this._closeStartIfNecessary();
        this._pushOutputtedElement(name);
        Writer out = this._out;
        out.write(60);
        out.write(name);
        this._closeStart = true;
        this._writePassThroughAttributes();
    }

    private void _writePassThroughAttributes() throws IOException {
        if (this._passThroughAttributes != null) {
            for (Map.Entry<String, Object> entry : this._passThroughAttributes.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if ("elementName".equals(key)) continue;
                if (value instanceof ValueExpression) {
                    value = ((ValueExpression)value).getValue(FacesContext.getCurrentInstance().getELContext());
                }
                if (value == null) continue;
                this.writeAttribute(key, value, null);
            }
            this._passThroughAttributes = null;
        }
    }

    private void _writeValue(Class<?> valueClass, Object value, boolean isAttribute) throws IOException {
        assert (valueClass != _CHAR_ARRAY_CLASS) : "Character arrays not supported as HTML attributes";
        if (valueClass == _INTEGER_CLASS) {
            this._out.write(IntegerUtils.getString((Integer)((Integer)value)));
            return;
        }
        String stringValue = value.toString();
        if (isAttribute) {
            HTMLEscapes.writeAttribute(this._out, this._buffer, stringValue);
        } else {
            HTMLEscapes.writeText(this._out, this._buffer, stringValue);
        }
    }

    private void _closeStartIfNecessary() throws IOException {
        this._markPendingElements();
        if (this._closeStart) {
            if (this._currAttr != null) {
                this._out.write(34);
                this._currAttr = null;
            }
            this._out.write(62);
            this._closeStart = false;
        }
    }

    private void _outputPendingElements() throws IOException {
        String pendingElement = this._pendingElement;
        if (pendingElement != null) {
            this._pendingElement = null;
            this._startElementImpl(pendingElement);
        }
    }

    private void _markPendingElements() {
        String pendingElement = this._pendingElement;
        if (pendingElement != null) {
            this._pushSkippedElement();
            this._pendingElement = null;
        }
    }

    private String _popSkippedElement() {
        int size = this._skippedElements.size();
        if (size == 0) {
            return null;
        }
        return this._skippedElements.remove(size - 1);
    }

    private void _pushSkippedElement() {
        this._skippedElements.add(null);
    }

    private void _pushOutputtedElement(String name) {
        this._skippedElements.add(name);
    }

    private static boolean _isEmptyElement(String name) {
        String[] array = _emptyElementArr[name.charAt(0)];
        if (array != null) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (!name.equalsIgnoreCase(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    static {
        HtmlResponseWriter._emptyElementArr[97] = _aNames;
        HtmlResponseWriter._emptyElementArr[65] = _aNames;
        HtmlResponseWriter._emptyElementArr[98] = _bNames;
        HtmlResponseWriter._emptyElementArr[66] = _bNames;
        HtmlResponseWriter._emptyElementArr[99] = _cNames;
        HtmlResponseWriter._emptyElementArr[67] = _cNames;
        HtmlResponseWriter._emptyElementArr[101] = _eNames;
        HtmlResponseWriter._emptyElementArr[69] = _eNames;
        HtmlResponseWriter._emptyElementArr[102] = _fNames;
        HtmlResponseWriter._emptyElementArr[70] = _fNames;
        HtmlResponseWriter._emptyElementArr[104] = _hNames;
        HtmlResponseWriter._emptyElementArr[72] = _hNames;
        HtmlResponseWriter._emptyElementArr[105] = _iNames;
        HtmlResponseWriter._emptyElementArr[73] = _iNames;
        HtmlResponseWriter._emptyElementArr[108] = _lNames;
        HtmlResponseWriter._emptyElementArr[76] = _lNames;
        HtmlResponseWriter._emptyElementArr[109] = _mNames;
        HtmlResponseWriter._emptyElementArr[77] = _mNames;
        HtmlResponseWriter._emptyElementArr[112] = _pNames;
        HtmlResponseWriter._emptyElementArr[80] = _pNames;
        _CHAR_ARRAY_CLASS = new char[0].getClass();
        _BOOLEAN_CLASS = Boolean.class;
        _INTEGER_CLASS = Integer.class;
        _LOG = TrinidadLogger.createTrinidadLogger(HtmlResponseWriter.class);
    }
}

