/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.laf.browser;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.laf.browser.BlafImageUtils;
import org.apache.myfaces.trinidadinternal.image.painter.AbstractBorderPainter;
import org.apache.myfaces.trinidadinternal.image.painter.AdjustableBorderPainter;
import org.apache.myfaces.trinidadinternal.image.painter.ColorChange;
import org.apache.myfaces.trinidadinternal.image.painter.ImmInsets;
import org.apache.myfaces.trinidadinternal.image.painter.OffscreenWrappingPainter;
import org.apache.myfaces.trinidadinternal.image.painter.PaintContext;
import org.apache.myfaces.trinidadinternal.image.painter.Painter;
import org.apache.myfaces.trinidadinternal.image.painter.TextPainter;
import org.apache.myfaces.trinidadinternal.style.util.FontProxy;

public class ButtonPainter
extends AbstractBorderPainter
implements ImageConstants {
    private static final String _STYLE_NAME = "BLAFServerButtonText";
    private static final String _DISABLED_STYLE_NAME = "BLAFServerButtonTextDisabled";
    private static final String _BORDER_STYLE_NAME = "AFDarkAccentBackground";
    private static final FontProxy _DEFAULT_FONT_PROXY = new FontProxy("Dialog", 0, 12);
    private static final Color _DEFAULT_FOREGROUND = BlafImageUtils.__TEXT_FOREGROUND_COLOR;
    private static final Color _DEFAULT_DISABLED_FOREGROUND = BlafImageUtils.__VERY_DARK_ACCENT_COLOR;
    private static final Color _DEFAULT_BACKGROUND = BlafImageUtils.__LIGHT_ACCENT_COLOR;
    private static final Color _DEFAULT_BORDER_COLOR = BlafImageUtils.__DARK_ACCENT_COLOR;
    private static final int _TOP = 1;
    private static final int _BOTTOM = 2;
    private static final int _START = 2;
    private static final int _END = 3;
    private static final int _TEXT_TOP_MARGIN = 0;
    private static final int _TEXT_BOTTOM_MARGIN = 0;
    private static final int _TEXT_START_MARGIN = 2;
    private static final int _TEXT_END_MARGIN = 3;

    public ButtonPainter() {
        this(0, 0);
    }

    ButtonPainter(int topMargin, int bottomMargin) {
        super(new AdjustableBorderPainter(new DisabledColorChange(new OffscreenWrappingPainter(new TextPainter(TEXT_KEY))), topMargin, 2, bottomMargin, 3, "BLAFServerButtonPadding"));
    }

    public static Color getDefaultForeground(ImageContext context, boolean disabled) {
        String styleName = disabled ? _DISABLED_STYLE_NAME : _STYLE_NAME;
        Color color = BlafImageUtils.__getNamedForeground(context, styleName);
        if (color == null) {
            color = disabled ? _DEFAULT_DISABLED_FOREGROUND : _DEFAULT_FOREGROUND;
        }
        return color;
    }

    public static Color getDefaultBackground(ImageContext context, boolean disabled) {
        String styleName = disabled ? _DISABLED_STYLE_NAME : _STYLE_NAME;
        Color color = BlafImageUtils.__getNamedBackground(context, styleName);
        if (color == null) {
            color = _DEFAULT_BACKGROUND;
        }
        return color;
    }

    public static FontProxy getDefaultFont() {
        return _DEFAULT_FONT_PROXY;
    }

    public static Color getDefaultBorderColor(ImageContext context, boolean disabled) {
        Color color = BlafImageUtils.__getNamedBackground(context, _BORDER_STYLE_NAME);
        if (color == null) {
            color = _DEFAULT_BORDER_COLOR;
        }
        return color;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        int start = 2;
        int top = 1;
        int end = 3;
        int bottom = 2;
        int height = this._getHeight(context);
        int halfCurveWidth = this._getCurveWidth(height) / 2;
        if (this._hasStartCurve(context)) {
            start = halfCurveWidth;
        }
        if (this._hasEndCurve(context)) {
            end = halfCurveWidth;
        }
        if (context.getReadingDirection() == 2) {
            return new ImmInsets(top, end, bottom, start);
        }
        return new ImmInsets(top, start, bottom, end);
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color background = context.getPaintBackground();
        Color borderColor = this._getBorderColor(context);
        Color darker = null;
        Color dark = null;
        Color light = null;
        if (ButtonPainter._isDisabled(context)) {
            dark = light = BlafImageUtils.__getDarkerColor(borderColor);
            darker = light;
        } else {
            light = BlafImageUtils.__getDarkerColor(borderColor);
            dark = BlafImageUtils.__getDarkerColor(light);
            darker = BlafImageUtils.__getDarkerColor(dark);
        }
        int startXOffset = 1;
        int endXOffset = 1;
        if (this._hasStartCurve(context)) {
            startXOffset = this._drawStartCurve(context, g, x, y, width, height, background, light, dark);
        } else {
            this._drawStartLine(context, g, x, y, width, height, light);
        }
        if (this._hasEndCurve(context)) {
            endXOffset = this._drawEndCurve(context, g, x, y, width, height, background, dark, darker);
        } else {
            this._drawEndLine(context, g, x, y, width, height, dark, darker);
        }
        this._fillBackground(context, g, x, y, width, height, startXOffset, endXOffset, background);
        this._drawTopLine(context, g, x, y, width, startXOffset, endXOffset, light);
        this._drawBottomLine(context, g, x, y, width, height, startXOffset, endXOffset, borderColor, dark, darker);
    }

    private int _drawEndCurve(PaintContext context, Graphics g, int x, int y, int width, int height, Color background, Color dark, Color darker) {
        int boxWidth = height / 2;
        if (this._isRightToLeft(context)) {
            int tempX = x;
            g.setColor(darker);
            g.fillArc(tempX, y, boxWidth + 1, height, 195, 75);
            g.setColor(dark);
            g.fillArc(tempX, y, boxWidth + 1, height, 197, -112);
            g.setColor(background);
            g.fillArc(tempX + 2, y + 1, boxWidth, height - 3, 90, 180);
        } else {
            int tempX = x + width - boxWidth - 1;
            g.setColor(darker);
            g.fillArc(tempX, y, boxWidth, height, -15, -75);
            g.setColor(dark);
            g.fillArc(tempX, y, boxWidth, height, -17, 112);
            g.setColor(background);
            g.fillArc(tempX, y + 1, boxWidth - 1, height - 3, 90, -180);
        }
        return boxWidth / 2;
    }

    private void _drawEndLine(PaintContext context, Graphics g, int x, int y, int width, int height, Color dark, Color darker) {
        int innerX = x + 1;
        int outerX = x;
        if (!this._isRightToLeft(context)) {
            innerX = x + width - 2;
            outerX = x + width - 1;
        }
        g.setColor(dark);
        g.drawLine(innerX, y + 1, innerX, y + height - 1);
        g.setColor(darker);
        g.drawLine(outerX, y + 1, outerX, y + height);
    }

    private int _drawStartCurve(PaintContext context, Graphics g, int x, int y, int width, int height, Color background, Color light, Color dark) {
        int boxWidth = height / 2;
        if (this._isRightToLeft(context)) {
            int tempX = x + width - boxWidth - 1;
            g.setColor(dark);
            g.fillArc(tempX, y - 1, boxWidth, height + 1, 354, -84);
            g.setColor(light);
            g.fillArc(tempX, y, boxWidth, height + 1, 90, -102);
            g.setColor(background);
            g.fillArc(tempX, y + 1, boxWidth - 1, height - 2, 90, -180);
        } else {
            int tempX = x;
            g.setColor(dark);
            g.fillArc(tempX, y - 1, boxWidth + 1, height + 1, 186, 84);
            g.setColor(light);
            g.fillArc(tempX, y, boxWidth + 1, height + 1, 90, 102);
            g.setColor(background);
            g.fillArc(tempX + 1, y + 1, boxWidth, height - 2, 90, 180);
        }
        return boxWidth / 2;
    }

    private void _drawStartLine(PaintContext context, Graphics g, int x, int y, int width, int height, Color color) {
        g.setColor(color);
        if (this._isRightToLeft(context)) {
            x = x + width - 1;
        }
        g.drawLine(x, y, x, y + height - 1);
    }

    private void _drawBottomLine(PaintContext context, Graphics g, int x, int y, int width, int height, int startXOffset, int endXOffset, Color light, Color dark, Color darker) {
        int outerX3;
        int outerX2;
        int outerX1;
        int innerX2;
        int innerX1;
        if (this._isRightToLeft(context)) {
            innerX1 = x + endXOffset + 1;
            innerX2 = x + width - startXOffset + 1;
            outerX1 = x + width - startXOffset;
            outerX2 = x + endXOffset + 1;
            outerX3 = outerX1 - 1;
        } else {
            innerX1 = x + startXOffset - 2;
            innerX2 = x + width - endXOffset - 2;
            outerX1 = x + startXOffset - 1;
            outerX2 = x + width - endXOffset - 2;
            outerX3 = outerX1 + 1;
        }
        g.setColor(dark);
        g.drawLine(innerX1, y + height - 2, innerX2, y + height - 2);
        int y1 = y + height - 1;
        g.setColor(darker);
        g.drawLine(outerX1, y1, outerX2, y1);
        g.setColor(light);
        g.drawLine(outerX1, y1, outerX1, y1);
        g.setColor(dark);
        g.drawLine(outerX3, y1, outerX3, y1);
    }

    private void _drawTopLine(PaintContext context, Graphics g, int x, int y, int width, int startXOffset, int endXOffset, Color light) {
        g.setColor(light);
        if (this._isRightToLeft(context)) {
            g.drawLine(x + endXOffset, y, x + width - startXOffset - 1, y);
        } else {
            g.drawLine(x + startXOffset, y, x + width - endXOffset - 1, y);
        }
    }

    private void _fillBackground(PaintContext context, Graphics g, int x, int y, int width, int height, int startXOffset, int endXOffset, Color background) {
        g.setColor(background);
        if (this._isRightToLeft(context)) {
            g.fillRect(x + endXOffset + 1, y + 1, x + width - startXOffset - endXOffset - 1, height - 2);
        } else {
            g.fillRect(x + startXOffset, y + 1, x + width - endXOffset - startXOffset - 1, height - 2);
        }
    }

    private int _getHeight(PaintContext context) {
        FontMetrics metrics = context.getFontMetrics(context.getPaintFont());
        int fontHeight = metrics.getHeight() - metrics.getLeading();
        int height = fontHeight + 1 + 2 + 0 + 0;
        return height;
    }

    private int _getCurveWidth(int height) {
        return (int)((double)height * 0.75);
    }

    private Color _getBorderColor(PaintContext context) {
        Color color = (Color)context.getPaintData(BORDER_COLOR_KEY);
        if (color != null) {
            return color;
        }
        return ButtonPainter.getDefaultBorderColor(context.getImageContext(), ButtonPainter._isDisabled(context));
    }

    static boolean _isDisabled(PaintContext context) {
        return (context.getPaintState() & 1) != 0;
    }

    private boolean _isRightToLeft(PaintContext context) {
        return context.getReadingDirection() == 2;
    }

    private boolean _hasStartCurve(PaintContext context) {
        return !Boolean.FALSE.equals(context.getPaintData(START_ROUNDED_KEY));
    }

    private boolean _hasEndCurve(PaintContext context) {
        return !Boolean.FALSE.equals(context.getPaintData(END_ROUNDED_KEY));
    }

    private static class DisabledColorChange
    extends ColorChange {
        public DisabledColorChange(Painter wrappedPainter) {
            super(wrappedPainter);
        }

        @Override
        protected Color getColor(PaintContext context) {
            Object foreground = context.getPaintData(ImageConstants.FOREGROUND_KEY);
            if (foreground != null) {
                return (Color)foreground;
            }
            return ButtonPainter.getDefaultForeground(context.getImageContext(), ButtonPainter._isDisabled(context));
        }
    }
}

