/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.el;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class Tokenizer
implements Iterator<Token> {
    private final String _exp;
    private int _curIndex = 0;
    private int _state = 100;
    private Token _curToken = null;
    private static final int _STATE_INIT = 100;
    private static final int _STATE_EXP_START = 200;
    private static final int _STATE_EXP = 300;
    public static final int TEXT_TYPE = 100;
    public static final int EXP_START_TYPE = 200;
    public static final int EXP_END_TYPE = 300;
    public static final int WHITE_SPACE_TYPE = 400;
    public static final int QUOTED_TYPE = 500;
    public static final int VAR_TYPE = 600;
    public static final int NUMBER_TYPE = 700;
    public static final int OPER_TYPE = 800;

    public Tokenizer(String expression) {
        this._exp = expression;
        this._curToken = this._next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this._curToken != null;
    }

    @Override
    public Token next() {
        if (this._curToken == null) {
            throw new NoSuchElementException();
        }
        Token tok = this._curToken;
        this._curToken = this._next();
        return tok;
    }

    private Token _next() {
        Token tok;
        int size = this._exp.length();
        if (this._curIndex >= size) {
            return null;
        }
        if (this._state == 100) {
            int loc = this._exp.indexOf("#{", this._curIndex);
            if (loc < 0) {
                loc = size;
            }
            this._state = 200;
            if (loc > this._curIndex) {
                tok = new Token(100, this._curIndex, loc);
                this._curIndex = loc;
            } else {
                tok = this._next();
            }
        } else if (this._state == 200) {
            int end = this._curIndex + 2;
            tok = new Token(200, this._curIndex, end);
            this._curIndex = end;
            this._state = 300;
        } else if (this._state == 300) {
            char ch;
            int start = this._curIndex;
            if (Character.isWhitespace(ch = this._exp.charAt(this._curIndex++))) {
                tok = this._readWhiteSpace(start);
            } else if (Character.isDigit(ch)) {
                tok = this._readNumber(start);
            } else if (Character.isJavaIdentifierStart(ch)) {
                tok = this._readVar(start);
            } else if ('}' == ch) {
                tok = new Token(300, start, this._curIndex);
                this._state = 100;
            } else {
                tok = '\"' == ch || '\'' == ch ? this._readQuoted(start, ch) : new Token(800, start, this._curIndex);
            }
        } else {
            throw new AssertionError((Object)("invalid state:" + this._state));
        }
        return tok;
    }

    private Token _readQuoted(int start, char quote) {
        int end = start + 1;
        while ((end = this._exp.indexOf(quote, end)) >= 0) {
            if (this._exp.charAt(++end - 2) == '\\') continue;
            this._curIndex = end;
            return new Token(500, start, end);
        }
        throw this._fatal("Cannot find matching quote", start);
    }

    private RuntimeException _fatal(String message, int charPos) {
        return new IllegalArgumentException(message + ". character position:" + charPos);
    }

    private Token _readVar(int start) {
        int end = start + 1;
        while (this._exp.charAt(end = this._getLastLocOfAlpha(end)) == '.') {
            ++end;
        }
        this._curIndex = end;
        return new Token(600, start, this._curIndex);
    }

    private int _getLastLocOfAlpha(int start) {
        while (Character.isJavaIdentifierPart(this._exp.charAt(start))) {
            ++start;
        }
        return start;
    }

    private Token _readNumber(int start) {
        int end = this._getLastLocOfDigit(start + 1);
        if (this._exp.charAt(end) == '.') {
            end = this._getLastLocOfDigit(end + 1);
        }
        this._curIndex = end;
        return new Token(700, start, end);
    }

    private int _getLastLocOfDigit(int start) {
        while (Character.isDigit(this._exp.charAt(start))) {
            ++start;
        }
        return start;
    }

    private Token _readWhiteSpace(int start) {
        while (Character.isWhitespace(this._exp.charAt(this._curIndex))) {
            ++this._curIndex;
        }
        return new Token(400, start, this._curIndex);
    }

    public final class Token {
        public final int type;
        private final int _start;
        private final int _end;

        private Token(int type, int start, int end) {
            this.type = type;
            this._start = start;
            this._end = end;
        }

        public String getText() {
            return Tokenizer.this._exp.substring(this._start, this._end);
        }
    }
}

