/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.upload;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.trinidad.model.ExtendedUploadedFile;
import org.apache.myfaces.trinidad.model.UploadedFile;

public class UploadedFileImpl
extends ExtendedUploadedFile {
    private String _filename;
    private String _tempFilename;
    private String _contentType;
    private Map<String, Object> _properties = new HashMap<String, Object>();
    private transient long _length;
    private transient File _file;
    private transient ArrayList<byte[]> _buffers;
    private transient int _sizeOfLastBuffer;
    private static final int _MEMORY_BUFFER_SIZE = 2048;
    private static final int _DISK_BUFFER_SIZE = 8192;
    private static final long serialVersionUID = 3895593282556327786L;

    UploadedFileImpl() {
    }

    public String getFilename() {
        return this._filename;
    }

    public String getContentType() {
        return this._contentType;
    }

    public long getLength() {
        return this._length;
    }

    public Object getOpaqueData() {
        return null;
    }

    public Map<String, Object> getProperties() {
        return this._properties;
    }

    public InputStream getInputStream() throws IOException {
        if (this._buffers != null) {
            return new BufferIS(this._buffers, this._sizeOfLastBuffer);
        }
        if (this._file == null && this._tempFilename != null) {
            this._file = new File(this._tempFilename);
        }
        if (this._file != null) {
            return new BufferedInputStream(new FileInputStream(this._file));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeFile(OutputStream out) throws IOException {
        if (this._buffers != null) {
            int size = this._buffers.size();
            for (int i = 0; i < size; ++i) {
                byte[] buffer = this._buffers.get(i);
                int bytes = i == size - 1 ? this._sizeOfLastBuffer : buffer.length;
                out.write(buffer, 0, bytes);
            }
        } else if (this._file != null) {
            try (FileInputStream in = new FileInputStream(this._file);){
                int bytes;
                byte[] buffer = new byte[8192];
                while ((bytes = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, bytes);
                }
            }
        }
    }

    public void dispose() {
        this._length = 0L;
        this._buffers = null;
        if (this._file != null) {
            this._file.delete();
            this._file = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(UploadedFile file, long remainingMemory, long remainingDiskSpace, String directory) throws IOException {
        block12: {
            int bytes;
            byte[] buffer;
            this._filename = file.getFilename();
            this._contentType = file.getContentType();
            if (file instanceof ExtendedUploadedFile) {
                this._properties = ((ExtendedUploadedFile)file).getProperties();
            }
            InputStream in = file.getInputStream();
            while (this._length < remainingMemory) {
                int size = Math.min((int)(remainingMemory - this._length) + 1, 2048);
                buffer = new byte[size];
                this._sizeOfLastBuffer = bytes = this._fillBuffer(in, buffer, size);
                this._length += (long)bytes;
                if (this._buffers == null) {
                    this._buffers = new ArrayList();
                }
                this._buffers.add(buffer);
                if (bytes >= size) continue;
                return;
            }
            if (this._length > remainingDiskSpace) {
                this._buffers = null;
                this._length = 0L;
                throw new EOFException("Per-request disk space limits exceeded.");
            }
            OutputStream out = this._createOutputStream(directory);
            try {
                try {
                    if (this._length > 0L) {
                        this._writeFile(out);
                    }
                    this._buffers = null;
                    while (this._length < remainingDiskSpace) {
                        buffer = new byte[8192];
                        bytes = this._fillBuffer(in, buffer, 8192);
                        out.write(buffer, 0, bytes);
                        this._length += (long)bytes;
                        if (bytes >= 8192) continue;
                    }
                }
                finally {
                    out.close();
                    if (this._length > remainingDiskSpace) {
                        this._file.delete();
                        this._file = null;
                        this._length = 0L;
                        throw new EOFException("Per-request disk space limits exceeded.");
                    }
                }
            }
            catch (Throwable e) {
                if (this._file == null) break block12;
                this._file.delete();
            }
        }
    }

    public int hashCode() {
        if (this._filename == null) {
            return 0;
        }
        return this._filename.hashCode();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    private OutputStream _createOutputStream(String directory) throws IOException {
        File tempDir = directory == null ? null : new File(directory);
        this._file = File.createTempFile("uix", null, tempDir);
        this._tempFilename = this._file.getCanonicalPath();
        return new FileOutputStream(this._file);
    }

    boolean __isInMemory() {
        return this._buffers != null;
    }

    private int _fillBuffer(InputStream in, byte[] buffer, int size) throws IOException {
        int bytes;
        int offset = 0;
        while ((bytes = in.read(buffer, offset, size - offset)) >= 0 && (offset += bytes) < size) {
        }
        return offset;
    }

    private static class BufferIS
    extends InputStream {
        private List<byte[]> _bufferList;
        private int _sizeOfLastBuffer;
        private int _bufferIndex;
        private int _bufferPos;

        public BufferIS(List<byte[]> bufferList, int sizeOfLastBuffer) {
            this._bufferList = bufferList;
            this._sizeOfLastBuffer = sizeOfLastBuffer;
        }

        @Override
        public int read() {
            int bufferIndex = this._bufferIndex;
            if (bufferIndex < 0) {
                return -1;
            }
            byte[] buffer = this._getBuffer(bufferIndex);
            byte currByte = buffer[this._bufferPos];
            int bufferSize = this._getBufferSize(buffer, bufferIndex);
            this._advanceTo(this._bufferPos + 1, bufferSize);
            return currByte & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            int bufferIndex = this._bufferIndex;
            if (bufferIndex < 0) {
                return -1;
            }
            byte[] buffer = this._getBuffer(bufferIndex);
            int bufferSize = this._getBufferSize(buffer, bufferIndex);
            int bufferPos = this._bufferPos;
            int bytes = Math.min(len, bufferSize - bufferPos);
            System.arraycopy(buffer, bufferPos, b, off, bytes);
            this._advanceTo(bufferPos + bytes, bufferSize);
            return bytes;
        }

        @Override
        public int available() {
            int bufferIndex = this._bufferIndex;
            if (bufferIndex < 0) {
                return 0;
            }
            byte[] buffer = this._getBuffer(bufferIndex);
            int bufferSize = this._getBufferSize(buffer, bufferIndex);
            return bufferSize - this._bufferPos;
        }

        private void _advanceTo(int pos, int bufferSize) {
            if (pos >= bufferSize) {
                this._bufferPos = 0;
                ++this._bufferIndex;
                if (this._bufferIndex >= this._bufferList.size()) {
                    this._bufferIndex = -1;
                }
            } else {
                this._bufferPos = pos;
            }
        }

        private int _getBufferSize(byte[] buffer, int bufferIndex) {
            if (bufferIndex == this._bufferList.size() - 1) {
                return this._sizeOfLastBuffer;
            }
            return buffer.length;
        }

        private byte[] _getBuffer(int bufferIndex) {
            return this._bufferList.get(bufferIndex);
        }
    }
}

