/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.validator;

import java.io.UnsupportedEncodingException;
import java.nio.charset.IllegalCharsetNameException;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.util.MessageFactory;
import org.apache.myfaces.trinidad.validator.ValidatorUtils;

public class ByteLengthValidator
implements StateHolder,
Validator {
    public static final String MAXIMUM_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.ByteLengthValidator.MAXIMUM";
    public static final String VALIDATOR_ID = "org.apache.myfaces.trinidad.ByteLength";
    private static final FacesBean.Type _TYPE = new FacesBean.Type();
    private static final PropertyKey _ENCODING_KEY = _TYPE.registerKey("encoding", String.class, "iso-8859-1");
    private static final PropertyKey _MAXIMUM_KEY = _TYPE.registerKey("maximum", Integer.TYPE, 0);
    private static final PropertyKey _MAXIMUM_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailMaximum", String.class);
    private static final PropertyKey _HINT_MAXIMUM_KEY = _TYPE.registerKey("hintMaximum", String.class);
    private static final PropertyKey _DISABLED_KEY = _TYPE.registerKey("disabled", Boolean.class, Boolean.FALSE);
    private FacesBean _facesBean = ValidatorUtils.getFacesBean(_TYPE);
    private boolean _isTransient = false;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ByteLengthValidator.class);

    public ByteLengthValidator() {
        this.setEncoding("iso-8859-1");
    }

    public ByteLengthValidator(int maximum, String encoding) {
        this.setMaximum(maximum);
        this.setEncoding(encoding);
    }

    public void setEncoding(String encoding) {
        this._facesBean.setProperty(_ENCODING_KEY, encoding);
    }

    public String getEncoding() {
        Object encoding = this._facesBean.getProperty(_ENCODING_KEY);
        return ComponentUtils.resolveString(encoding);
    }

    public void setMaximum(int maximum) {
        this._facesBean.setProperty(_MAXIMUM_KEY, maximum);
    }

    public int getMaximum() {
        return ComponentUtils.resolveInteger(this._facesBean.getProperty(_MAXIMUM_KEY));
    }

    public void setMessageDetailMaximum(String maximumMessageDetail) {
        this._facesBean.setProperty(_MAXIMUM_MESSAGE_DETAIL_KEY, maximumMessageDetail);
    }

    public String getMessageDetailMaximum() {
        Object obj = this._facesBean.getProperty(_MAXIMUM_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void setHintMaximum(String hintMaximum) {
        this._facesBean.setProperty(_HINT_MAXIMUM_KEY, hintMaximum);
    }

    public String getHintMaximum() {
        Object obj = this._facesBean.getProperty(_HINT_MAXIMUM_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (this.isDisabled()) {
            return;
        }
        if (context == null || component == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_FACESCONTEXT_OR_UICOMPONENT"));
        }
        if (value != null) {
            ValidatorUtils.assertIsString(value, "'value' is not of type java.lang.String.");
            String theValue = (String)value;
            if (theValue.isEmpty()) {
                return;
            }
            int maxBytes = this.getMaximum();
            try {
                byte[] bytes = theValue.getBytes(this.getEncoding());
                if (bytes.length > maxBytes) {
                    throw new ValidatorException(this.getLengthValidationFailureMessage(context, component, theValue));
                }
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalCharsetNameException(_LOG.getMessage("ENCODING_NOT_SUPPORTED_BY_JVM", this.getEncoding()));
            }
        }
    }

    public Object saveState(FacesContext context) {
        return this._facesBean.saveState(context);
    }

    public void restoreState(FacesContext context, Object state) {
        this._facesBean.restoreState(context, state);
    }

    public boolean isTransient() {
        return this._isTransient;
    }

    public void setTransient(boolean transientValue) {
        this._isTransient = transientValue;
    }

    public void setValueExpression(String name, ValueExpression expression) {
        ValidatorUtils.setValueExpression(this._facesBean, name, expression);
    }

    public ValueExpression getValueExpression(String name) {
        return ValidatorUtils.getValueExpression(this._facesBean, name);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        ValidatorUtils.setValueBinding(this._facesBean, name, binding);
    }

    public ValueBinding getValueBinding(String name) {
        return ValidatorUtils.getValueBinding(this._facesBean, name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ByteLengthValidator) {
            ByteLengthValidator other = (ByteLengthValidator)object;
            String encoding = this.getEncoding();
            String otherEncoding = other.getEncoding();
            String otherMsgMaxDet = other.getMessageDetailMaximum();
            String msgMaxDet = this.getMessageDetailMaximum();
            if (this.isDisabled() == other.isDisabled() && this.isTransient() == other.isTransient() && ValidatorUtils.equals(encoding, otherEncoding) && ValidatorUtils.equals(msgMaxDet, otherMsgMaxDet) && this.getMaximum() == other.getMaximum()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        String maximumMsgDet = this.getMessageDetailMaximum();
        String encoding = this.getEncoding();
        result = 37 * result + (encoding == null ? 0 : encoding.hashCode());
        result = 37 * result + (this._isTransient ? 0 : 1);
        result = 37 * result + (this.isDisabled() ? 1 : 0);
        result = 37 * result + this.getMaximum();
        result = 37 * result + (maximumMsgDet == null ? 0 : maximumMsgDet.hashCode());
        return result;
    }

    public void setDisabled(boolean isDisabled) {
        this._facesBean.setProperty(_DISABLED_KEY, isDisabled);
    }

    public boolean isDisabled() {
        Boolean disabled = (Boolean)this._facesBean.getProperty(_DISABLED_KEY);
        return disabled != null ? disabled : false;
    }

    protected FacesMessage getLengthValidationFailureMessage(FacesContext context, UIComponent component, String value) {
        Object label = ValidatorUtils.getComponentLabel(component);
        Object maxMesgDetail = this._getRawMaximumMessageDetail();
        String maximumBytes = String.valueOf(this.getMaximum());
        Object[] params = new Object[]{label, value, maximumBytes};
        FacesMessage msg = MessageFactory.getMessage(context, MAXIMUM_MESSAGE_ID, maxMesgDetail, params, component);
        return msg;
    }

    private Object _getRawMaximumMessageDetail() {
        return this._facesBean.getRawProperty(_MAXIMUM_MESSAGE_DETAIL_KEY);
    }
}

