/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.core.CoreStyleSheet;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.StyleProvider;

public class StyleSheetRenderer
extends XhtmlRenderer {
    private static final String _SUPPRESS_STYLESHEET_ID_PARAM = "org.apache.myfaces.trinidad.skin.suppressStylesheet";

    public StyleSheetRenderer() {
        this(CoreStyleSheet.TYPE);
    }

    protected StyleSheetRenderer(FacesBean.Type type) {
        super(type);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StyleContext sContext = ((CoreRenderingContext)rc).getStyleContext();
        StyleProvider provider = sContext.getStyleProvider();
        if (provider != null) {
            List<String> uris = provider.getStyleSheetURIs(sContext);
            boolean suppressStylesheet = this._isSuppressStylesheet(context, rc);
            if (!suppressStylesheet) {
                if (uris != null && !uris.isEmpty()) {
                    ExternalContext externalContext = context.getExternalContext();
                    String contextUri = externalContext.getRequestContextPath();
                    String baseURL = contextUri + "/adf/styles/cache/";
                    String outputMode = rc.getOutputMode();
                    if ("portlet".equals(outputMode) && StyleSheetRenderer.supportsScripting(rc)) {
                        writer.startElement("script", null);
                        writer.writeText((Object)"var _adfSS;if(!_adfSS){_adfSS=1;", null);
                        for (String uri : uris) {
                            writer.writeText((Object)"document.write(\"<link rel=\\\"stylesheet\\\" charset=\\\"UTF-8\\\" type=\\\"text/css\\\" href=\\\"", null);
                            uri = context.getExternalContext().encodeResourceURL(baseURL + uri);
                            writer.writeText((Object)uri, null);
                            writer.writeText((Object)"\\\">\");", null);
                        }
                        writer.writeText((Object)"}", null);
                        writer.endElement("script");
                    } else {
                        for (String uri : uris) {
                            writer.startElement("link", null);
                            this.renderId(context, comp);
                            writer.writeAttribute("rel", (Object)"stylesheet", null);
                            writer.writeAttribute("charset", (Object)"UTF-8", null);
                            String type = provider.getContentStyleType(sContext);
                            writer.writeAttribute("type", (Object)type, null);
                            this.renderEncodedResourceURI(context, "href", baseURL + uri);
                            writer.endElement("link");
                        }
                    }
                } else if (rc.getSkin() == null) {
                    writer.writeComment((Object)"ERROR: Could not create stylesheet, because no skin is available");
                } else {
                    writer.writeComment((Object)("ERROR: could not create stylesheet for " + rc.getSkin().getStyleSheetName()));
                }
            }
            if (rc instanceof CoreRenderingContext) {
                Map shortStyles = rc.getSkin().getStyleClassMap(rc);
                ((CoreRenderingContext)rc).setStyleMap(shortStyles);
            }
        }
    }

    private boolean _isSuppressStylesheet(FacesContext context, RenderingContext rc) {
        Map requestMap;
        boolean suppressStylesheet;
        if (!StyleSheetRenderer._supportsExternalStylesheet(rc)) {
            return true;
        }
        String outputMode = rc.getOutputMode();
        if ("portlet".equals(outputMode) && (suppressStylesheet = "true".equals((requestMap = context.getExternalContext().getRequestMap()).get(_SUPPRESS_STYLESHEET_ID_PARAM)))) {
            return ((CoreRenderingContext)rc).isRequestMapStyleSheetIdAndSkinEqual(context, rc.getSkin());
        }
        return false;
    }

    private static boolean _supportsExternalStylesheet(RenderingContext rc) {
        Object styleCapability = rc.getAgent().getCapabilities().get(TrinidadAgent.CAP_STYLE_ATTRIBUTES);
        return styleCapability == null || TrinidadAgent.STYLES_EXTERNAL == styleCapability;
    }
}

