/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.change.AttributeComponentChange;
import org.apache.myfaces.trinidad.model.RowKeySet;

public final class RowKeySetAttributeChange
extends AttributeComponentChange {
    private static final long serialVersionUID = 1L;
    private final String _clientId;

    public RowKeySetAttributeChange(String clientId, String propertyName, Object value) {
        super(propertyName, value);
        if (clientId == null || clientId.length() == 0) {
            throw new IllegalArgumentException("No clientId specified");
        }
        this._clientId = clientId;
    }

    public void changeComponent(UIComponent uiComponent) {
        Map attributeMap = uiComponent.getAttributes();
        Object attributeValue = this.getAttributeValue();
        String attributeName = this.getAttributeName();
        if (attributeValue instanceof ValueExpression) {
            uiComponent.setValueExpression(attributeName, (ValueExpression)attributeValue);
            attributeMap.remove(attributeName);
        } else if (attributeValue instanceof ValueBinding) {
            uiComponent.setValueBinding(attributeName, (ValueBinding)attributeValue);
            attributeMap.remove(attributeName);
        } else {
            if (attributeValue instanceof RowKeySet) {
                ValueExpression expression = uiComponent.getValueExpression(attributeName);
                FacesContext context = FacesContext.getCurrentInstance();
                if (expression != null) {
                    context.getViewRoot().invokeOnComponent(context, this._clientId, (ContextCallback)new GetOldValueAndUpdate(expression, (RowKeySet)attributeValue));
                } else {
                    context.getViewRoot().invokeOnComponent(context, this._clientId, (ContextCallback)new GetOldValueAndUpdate(attributeName, (RowKeySet)attributeValue));
                }
            }
            attributeMap.put(attributeName, attributeValue);
        }
    }

    private static void _updateKeySet(String clientId, RowKeySet oldKeySet, RowKeySet newKeySet) {
        if (oldKeySet != newKeySet) {
            if (clientId == null) {
                oldKeySet.clear();
                oldKeySet.addAll(newKeySet);
            } else {
                FacesContext context = FacesContext.getCurrentInstance();
                context.getViewRoot().invokeOnComponent(context, clientId, (ContextCallback)new RowKeySetUpdater(oldKeySet, newKeySet));
            }
        }
    }

    private static final class RowKeySetUpdater
    implements ContextCallback {
        private final RowKeySet _oldKeySet;
        private final RowKeySet _newKeySet;

        public RowKeySetUpdater(RowKeySet oldKeySet, RowKeySet newKeySet) {
            this._oldKeySet = oldKeySet;
            this._newKeySet = newKeySet;
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            this._oldKeySet.clear();
            this._oldKeySet.addAll(this._newKeySet);
        }
    }

    private static final class GetOldValueAndUpdate
    implements ContextCallback {
        private final ValueExpression _expression;
        private final String _attributeName;
        private final RowKeySet _newKeySet;

        public GetOldValueAndUpdate(ValueExpression expression, RowKeySet newKeySet) {
            this._attributeName = null;
            this._expression = expression;
            this._newKeySet = newKeySet;
        }

        public GetOldValueAndUpdate(String attributeName, RowKeySet newKeySet) {
            this._expression = null;
            this._attributeName = attributeName;
            this._newKeySet = newKeySet;
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            if (this._expression != null) {
                RowKeySetAttributeChange._updateKeySet(null, (RowKeySet)this._expression.getValue(context.getELContext()), this._newKeySet);
            } else {
                Map attributeMap = target.getAttributes();
                RowKeySet oldKeySet = (RowKeySet)attributeMap.get(this._attributeName);
                RowKeySetAttributeChange._updateKeySet(null, oldKeySet, this._newKeySet);
            }
        }
    }
}

