/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.xml.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludePropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludeStyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleNode {
    private final String _name;
    private final String _selector;
    private final List<PropertyNode> _properties;
    private final List<IncludeStyleNode> _includedStyles;
    private final List<IncludePropertyNode> _includedProperties;
    private final List<String> _inhibitedProperties;
    private final boolean _resetProperties;
    private final boolean _inhibitAll;
    private static final String _INHIBIT_ALL_VALUE = "all";

    public StyleNode(String name, String selector, PropertyNode[] properties, IncludeStyleNode[] includedStyles, IncludePropertyNode[] includedProperties, Set<String> inhibitedProperties) {
        this(name, selector, properties, includedStyles, includedProperties, inhibitedProperties, false);
    }

    StyleNode(String name, String selector, PropertyNode[] properties, IncludeStyleNode[] includedStyles, IncludePropertyNode[] includedProperties, Set<String> inhibitedProperties, boolean resetProperties) {
        this._name = name;
        this._selector = selector;
        this._resetProperties = resetProperties;
        this._properties = properties == null || properties.length == 0 ? Collections.emptyList() : (properties.length == 1 ? Collections.singletonList(properties[0]) : Collections.unmodifiableList(Arrays.asList(properties)));
        this._includedStyles = includedStyles == null || includedStyles.length == 0 ? Collections.emptyList() : (includedStyles.length == 1 ? Collections.singletonList(includedStyles[0]) : Collections.unmodifiableList(Arrays.asList(includedStyles)));
        this._includedProperties = includedProperties == null || includedProperties.length == 0 ? Collections.emptyList() : (includedProperties.length == 1 ? Collections.singletonList(includedProperties[0]) : Collections.unmodifiableList(Arrays.asList(includedProperties)));
        boolean inhibitAll = false;
        if (inhibitedProperties != null && !inhibitedProperties.isEmpty()) {
            ArrayList<String> inhibitedPropertiesList = new ArrayList<String>(inhibitedProperties.size());
            for (String property : inhibitedProperties) {
                if (_INHIBIT_ALL_VALUE.equalsIgnoreCase(property)) {
                    inhibitAll = true;
                    continue;
                }
                inhibitedPropertiesList.add(property);
            }
            this._inhibitedProperties = inhibitedPropertiesList.size() == 1 ? Collections.singletonList(inhibitedPropertiesList.get(0)) : Collections.unmodifiableList(inhibitedPropertiesList);
        } else {
            this._inhibitedProperties = Collections.emptyList();
        }
        this._inhibitAll = inhibitAll;
    }

    public String getName() {
        return this._name;
    }

    public String getSelector() {
        return this._selector;
    }

    public boolean isEmpty() {
        if (!this._properties.isEmpty()) {
            return false;
        }
        if (!this._includedStyles.isEmpty()) {
            return false;
        }
        return this._includedProperties.isEmpty();
    }

    public Collection<PropertyNode> getProperties() {
        return this._properties;
    }

    public Collection<IncludeStyleNode> getIncludedStyles() {
        return this._includedStyles;
    }

    public Collection<IncludePropertyNode> getIncludedProperties() {
        return this._includedProperties;
    }

    public Collection<String> getInhibitedProperties() {
        return this._inhibitedProperties;
    }

    public boolean isInhibitingAll() {
        return this._inhibitAll;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StyleNode)) {
            return false;
        }
        StyleNode test = (StyleNode)obj;
        return (this._name == test._name || this._name != null && this._name.equals(test._name)) && (this._selector == test._selector || this._selector != null && this._selector.equals(test._selector)) && this._resetProperties == test._resetProperties && this._inhibitAll == test._inhibitAll && this._inhibitedProperties.equals(test._inhibitedProperties) && this._includedStyles.equals(test._includedStyles) && this._includedProperties.equals(test._includedProperties) && this._properties.equals(test._properties);
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + (null == this._name ? 0 : this._name.hashCode());
        hash = 37 * hash + (null == this._selector ? 0 : this._selector.hashCode());
        hash = 37 * hash + (this._resetProperties ? 0 : 1);
        hash = 37 * hash + (this._inhibitAll ? 0 : 1);
        hash = 37 * hash + this._inhibitedProperties.hashCode();
        hash = 37 * hash + this._includedStyles.hashCode();
        hash = 37 * hash + this._includedProperties.hashCode();
        hash = 37 * hash + this._properties.hashCode();
        return hash;
    }

    public String toString() {
        return this.getClass().getName() + "[" + "name=" + this._name + ", " + "selector=" + this._selector + ", " + "properties=" + this._properties.toString() + ", " + "includeStyles=" + this._includedStyles.toString() + ", " + "includeProperties=" + this._includedProperties.toString() + ", " + "inhibitedProperties=" + this._inhibitedProperties.toString() + ", " + "resetProperties=" + this._resetProperties + ", " + "inhibitAll=" + this._inhibitAll + "]";
    }

    boolean __getResetProperties() {
        return this._resetProperties;
    }
}

