/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.xml.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.beans.BasePropertyDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectionPropertyDef
extends BasePropertyDef {
    private PropertyDescriptor _descriptor;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(IntrospectionPropertyDef.class);

    public IntrospectionPropertyDef(PropertyDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException();
        }
        this._descriptor = descriptor;
    }

    @Override
    public String getName() {
        return this._descriptor.getName();
    }

    @Override
    public Class<?> getPropertyType() {
        return this._descriptor.getPropertyType();
    }

    @Override
    public Object getValue(ParseContext context, Object bean) {
        Method read = this._descriptor.getReadMethod();
        if (read == null) {
            return null;
        }
        try {
            return read.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            _LOG.severe((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            _LOG.severe((Throwable)ite);
        }
        return null;
    }

    @Override
    public void setValue(ParseContext context, Object bean, Object value) {
        Method write = this._descriptor.getWriteMethod();
        if (write == null) {
            return;
        }
        try {
            write.invoke(bean, value);
        }
        catch (IllegalAccessException iae) {
            _LOG.severe((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            _LOG.severe((Throwable)ite);
        }
    }
}

