/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui;

import org.apache.myfaces.trinidadinternal.share.util.NamespaceMap;
import org.apache.myfaces.trinidadinternal.ui.LogicalNodeRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;

@Deprecated
public abstract class RenderedNodeRenderingContext
extends LogicalNodeRenderingContext {
    private static final int _DEFAULT_STACK_SIZE = 10;
    private static final int _DEFAULT_PROPERTY_MAP_SIZE = 31;
    private transient StackFrameMap _nodePropertyMap;
    private int _renderedStackDepth;
    private UINode[] _renderedNodeStack;
    private NamespaceMap _properties;

    public RenderedNodeRenderingContext() {
        int defaultStackSize = this.getDefaultNodeStackSize();
        this._renderedNodeStack = new UINode[defaultStackSize];
        this._nodePropertyMap = new StackFrameMap(defaultStackSize);
        this._properties = new NamespaceMap(this.getDefaultPropertyMapSize());
    }

    public int getRenderedAncestorNodeCount() {
        return this._renderedStackDepth;
    }

    public UINode getRenderedAncestorNode(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        int stackDepth = this._renderedStackDepth;
        if (index < stackDepth) {
            return this._renderedNodeStack[stackDepth - index - 1];
        }
        return null;
    }

    public void pushRenderedChild(UIXRenderingContext currentContext, UINode renderedChild) {
        int renderedStackDepth;
        if ((renderedStackDepth = this._renderedStackDepth++) >= this._renderedNodeStack.length) {
            UINode[] newStack = new UINode[this._renderedNodeStack.length * 2];
            System.arraycopy(this._renderedNodeStack, 0, newStack, 0, this._renderedNodeStack.length);
            this._renderedNodeStack = newStack;
        }
        this._renderedNodeStack[renderedStackDepth] = renderedChild;
        this._nodePropertyMap.pushFrame();
        super.pushRenderedChild(currentContext, renderedChild);
    }

    public void popRenderedChild(UIXRenderingContext currentContext) {
        int renderedStackDepth;
        super.popRenderedChild(currentContext);
        this._renderedStackDepth = renderedStackDepth = this._renderedStackDepth - 1;
        assert (renderedStackDepth >= 0);
        this._renderedNodeStack[renderedStackDepth] = null;
        this._nodePropertyMap.popFrame();
    }

    public Object getProperty(String namespace, Object key) {
        if (!"http://myfaces.apache.org/uix/ui".equals(namespace)) {
            return this._properties.get(namespace, key);
        }
        return this.getRenderingProperty(key);
    }

    public void setProperty(String namespace, Object key, Object value) {
        if (!"http://myfaces.apache.org/uix/ui".equals(namespace)) {
            this._properties.put(namespace, key, value);
        }
        this.setRenderingProperty(key, value);
    }

    protected abstract Object getRenderingProperty(Object var1);

    protected abstract void setRenderingProperty(Object var1, Object var2);

    public void setLocalProperty(Object key, Object value) {
        this._nodePropertyMap.set(key, value);
    }

    public Object getLocalProperty(int ancestorIndex, Object key, Object defaultValue) {
        return this._nodePropertyMap.get(ancestorIndex, key, defaultValue);
    }

    public Object clone() {
        RenderedNodeRenderingContext context = (RenderedNodeRenderingContext)super.clone();
        context._properties = (NamespaceMap)this._properties.clone();
        context._nodePropertyMap = (StackFrameMap)this._nodePropertyMap.clone();
        UINode[] renderedNodeStack = new UINode[this._renderedStackDepth];
        System.arraycopy(this._renderedNodeStack, 0, renderedNodeStack, 0, this._renderedStackDepth);
        context._renderedNodeStack = renderedNodeStack;
        return context;
    }

    protected int getDefaultNodeStackSize() {
        return 10;
    }

    protected int getDefaultPropertyMapSize() {
        return 31;
    }

    protected void reset() {
        super.reset();
        this._nodePropertyMap.clear();
        for (int i = 0; i < this._renderedStackDepth; ++i) {
            this._renderedNodeStack[i] = null;
        }
        this._properties.clear();
    }

    protected void resetProperties() {
        throw new UnsupportedOperationException();
    }

    private static class StackFrameMap
    implements Cloneable {
        private static final int _INITIAL_CAPACITY = 20;
        private static final int _MIN_STACK_SIZE = 4;
        private static final Object[] _EMPTY_ARRAY = new Object[0];
        private Object[] _keyValues;
        private int[] _frameStarts;
        private int _nextKeyIndex = 0;
        private int _frameIndex = -1;

        public StackFrameMap() {
            this(20);
        }

        public StackFrameMap(int initialCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException();
            }
            this._keyValues = initialCapacity != 0 ? new Object[initialCapacity * 4] : _EMPTY_ARRAY;
            this._frameStarts = new int[initialCapacity];
        }

        public void pushFrame() {
            ++this._frameIndex;
            if (this._frameStarts.length <= this._frameIndex) {
                int[] newStarts = new int[this._frameStarts.length * 2];
                System.arraycopy(this._frameStarts, 0, newStarts, 0, this._frameStarts.length);
                this._frameStarts = newStarts;
            }
            this._frameStarts[this._frameIndex] = this._nextKeyIndex;
        }

        public void popFrame() {
            int startIndex = this._getFrameKeyStartIndex();
            if (startIndex >= 0) {
                int endIndex = this._nextKeyIndex;
                for (int i = startIndex; i < endIndex; ++i) {
                    this._keyValues[i] = null;
                }
            }
            this._nextKeyIndex = startIndex;
            --this._frameIndex;
            if (this._frameIndex < -1) {
                throw new IllegalStateException();
            }
        }

        public Object get(int index, Object key, Object defaultValue) {
            int startIndex = this._getFrameKeyStartIndex(index);
            if (startIndex >= 0) {
                int endIndex = this._getFrameKeyEndIndex(index);
                for (int i = startIndex; i < endIndex; i += 2) {
                    if (key != this._keyValues[i]) continue;
                    return this._keyValues[i + 1];
                }
            }
            return defaultValue;
        }

        public void set(Object key, Object value) {
            int currSize;
            if (key == null) {
                throw new IllegalArgumentException();
            }
            int startIndex = this._getFrameKeyStartIndex();
            int endIndex = this._nextKeyIndex;
            if (startIndex >= 0) {
                for (int i = startIndex; i < endIndex; i += 2) {
                    if (key != this._keyValues[i]) continue;
                    this._keyValues[i + 1] = value;
                    return;
                }
            }
            if ((currSize = this._keyValues.length) < endIndex + 2) {
                int newSize = currSize <= 0 ? 8 : currSize * 2;
                Object[] newKeyValues = new Object[newSize];
                System.arraycopy(this._keyValues, 0, newKeyValues, 0, currSize);
                this._keyValues = newKeyValues;
            }
            this._keyValues[endIndex] = key;
            this._keyValues[endIndex + 1] = value;
            this._nextKeyIndex += 2;
        }

        public void clear() {
            if (this._frameIndex >= 0) {
                int endIndex = this._nextKeyIndex;
                for (int i = 0; i < endIndex; ++i) {
                    this._keyValues[i] = null;
                }
            }
            this._nextKeyIndex = 0;
            this._frameIndex = -1;
        }

        public Object clone() {
            StackFrameMap stack;
            try {
                stack = (StackFrameMap)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException();
            }
            Object[] keyValues = new Object[this._nextKeyIndex];
            System.arraycopy(this._keyValues, 0, keyValues, 0, this._nextKeyIndex);
            stack._keyValues = keyValues;
            int frameCount = this._frameIndex + 1;
            int[] frameStarts = new int[frameCount];
            System.arraycopy(this._frameStarts, 0, frameStarts, 0, frameCount);
            stack._frameStarts = frameStarts;
            return stack;
        }

        private int _getFrameKeyStartIndex() {
            return this._getFrameKeyStartIndex(0);
        }

        private int _getFrameKeyStartIndex(int ancestorCount) {
            if (this._frameIndex >= ancestorCount) {
                return this._frameStarts[this._frameIndex - ancestorCount];
            }
            return -1;
        }

        private int _getFrameKeyEndIndex(int ancestorCount) {
            if (ancestorCount == 0) {
                return this._nextKeyIndex;
            }
            return this._getFrameKeyStartIndex(ancestorCount - 1);
        }
    }
}

