/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.dispatch;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.myfaces.trinidadinternal.config.dispatch.DispatchResponseConfiguratorImpl;
import org.apache.myfaces.trinidadinternal.webapp.wrappers.RenderResponseWrapper;

class DispatchRenderResponse
extends RenderResponseWrapper {
    private final RenderRequest _request;
    private static final Pattern _CONTENT_TYPE_PATTERN = Pattern.compile("([^;]+)(?:;charset=(.*))?");

    public DispatchRenderResponse(ExternalContext ec) {
        super((RenderResponse)ec.getResponse());
        this._request = (RenderRequest)ec.getRequest();
    }

    public void setContentType(String contentTypeAndCharset) {
        Matcher matcher;
        if (contentTypeAndCharset != null && (matcher = _CONTENT_TYPE_PATTERN.matcher(contentTypeAndCharset)).matches()) {
            String userAgent;
            String contentType = matcher.group(1);
            String charset = matcher.groupCount() > 1 ? matcher.group(2) : null;
            this._request.setAttribute(DispatchResponseConfiguratorImpl.__CONTENT_TYPE_KEY, (Object)contentType);
            if ("application/xhtml+xml".equals(contentType) && (userAgent = this._request.getProperty("User-agent")) != null && userAgent.indexOf("compatible; MSIE") != -1) {
                contentTypeAndCharset = "text/html";
                if (charset != null) {
                    contentTypeAndCharset = contentTypeAndCharset + ";charset=" + charset;
                }
            }
        }
        super.setContentType(contentTypeAndCharset);
    }
}

