/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.captcha;

import java.io.IOException;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.myfaces.custom.captcha.CAPTCHAComponent;

public class CAPTCHARenderer
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        CAPTCHAComponent captchaComponent = (CAPTCHAComponent)component;
        this.generateImageTag(context, captchaComponent);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
    }

    private void generateImageTag(FacesContext context, CAPTCHAComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String captchaSessionKeyName = component.getCaptchaSessionKeyName();
        String width = component.getImageWidth();
        String height = component.getImageHeight();
        if (width == null) {
            width = "290";
        }
        if (height == null) {
            height = "81";
        }
        writer.startElement("img", (UIComponent)component);
        context.getAttributes().put("captchaSessionKeyName", captchaSessionKeyName);
        Resource resource = context.getApplication().getResourceHandler().createResource("captcha", "oam.custom.captcha");
        context.getAttributes().remove("captchaSessionKeyName");
        String url = resource.getRequestPath();
        writer.writeAttribute("src", (Object)url, null);
        writer.writeAttribute("width", (Object)width, null);
        writer.writeAttribute("height", (Object)height, null);
        writer.endElement("img");
    }
}

