/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.renderkit.html;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectOne;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class HtmlRadioRendererBase
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog(HtmlRadioRendererBase.class);
    private static final String PAGE_DIRECTION = "pageDirection";
    private static final String LINE_DIRECTION = "lineDirection";

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UISelectOne.class);
        UISelectOne selectOne = (UISelectOne)uiComponent;
        String layout = this.getLayout((UIComponent)selectOne);
        boolean pageDirectionLayout = false;
        if (layout != null) {
            if (layout.equals(PAGE_DIRECTION)) {
                pageDirectionLayout = true;
            } else if (layout.equals(LINE_DIRECTION)) {
                pageDirectionLayout = false;
            } else {
                log.error((Object)("Wrong layout attribute for component " + selectOne.getClientId(facesContext) + ": " + layout));
            }
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", (UIComponent)selectOne);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)selectOne, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
        HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        if (!pageDirectionLayout) {
            writer.startElement("tr", (UIComponent)selectOne);
        }
        List selectItemList = RendererUtils.getSelectItemList(selectOne);
        Converter converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, (UIComponent)selectOne);
        Object currentValue = RendererUtils.getObjectValue((UIComponent)selectOne);
        currentValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)selectOne, converter, currentValue);
        int itemNum = 0;
        for (SelectItem selectItem : selectItemList) {
            this.renderGroupOrItemRadio(facesContext, (UIComponent)selectOne, selectItem, currentValue, converter, pageDirectionLayout, new Integer(itemNum));
            ++itemNum;
        }
        if (!pageDirectionLayout) {
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected String getLayout(UIComponent selectOne) {
        if (selectOne instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)selectOne).getLayout();
        }
        return (String)selectOne.getAttributes().get("layout");
    }

    protected String getStyleClass(UISelectOne selectOne) {
        if (selectOne instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)selectOne).getStyleClass();
        }
        return (String)selectOne.getAttributes().get("styleClass");
    }

    protected void renderGroupOrItemRadio(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, Object currentValue, Converter converter, boolean pageDirectionLayout, Integer itemNum) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean isSelectItemGroup = selectItem instanceof SelectItemGroup;
        UISelectOne selectOne = (UISelectOne)uiComponent;
        if (isSelectItemGroup) {
            if (pageDirectionLayout) {
                writer.startElement("tr", (UIComponent)selectOne);
            }
            writer.startElement("td", (UIComponent)selectOne);
            if (selectItem.isEscape()) {
                writer.writeText((Object)selectItem.getLabel(), "label");
            } else {
                writer.write(selectItem.getLabel());
            }
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
                writer.startElement("tr", (UIComponent)selectOne);
            }
            writer.startElement("td", (UIComponent)selectOne);
            writer.startElement("table", (UIComponent)selectOne);
            writer.writeAttribute("border", (Object)"0", null);
            SelectItemGroup group = (SelectItemGroup)selectItem;
            SelectItem[] selectItems = group.getSelectItems();
            for (int i = 0; i < selectItems.length; ++i) {
                this.renderGroupOrItemRadio(facesContext, (UIComponent)selectOne, selectItems[i], currentValue, converter, pageDirectionLayout, new Integer(i));
            }
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("table");
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
            }
        } else {
            writer.write("\t\t");
            if (pageDirectionLayout) {
                writer.startElement("tr", (UIComponent)selectOne);
            }
            writer.startElement("td", (UIComponent)selectOne);
            String itemStrValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)selectOne, converter, selectItem.getValue());
            boolean itemDisabled = selectItem.isDisabled();
            boolean itemChecked = itemStrValue.equals(currentValue);
            String itemId = this.renderRadio(facesContext, (UIInput)selectOne, itemStrValue, itemDisabled, itemChecked, false, itemNum);
            boolean componentDisabled = this.isDisabled(facesContext, (UIComponent)selectOne);
            boolean disabled = componentDisabled || itemDisabled;
            HtmlRendererUtils.renderLabel(writer, (UIComponent)selectOne, itemId, selectItem, disabled);
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
            }
        }
    }

    @Deprecated
    protected void renderRadio(FacesContext facesContext, UIComponent uiComponent, String value, String label, boolean disabled, boolean checked, boolean renderId) throws IOException {
        this.renderRadio(facesContext, (UIInput)uiComponent, value, disabled, checked, renderId, 0);
    }

    protected String renderRadio(FacesContext facesContext, UIInput uiComponent, String value, boolean disabled, boolean checked, boolean renderId, Integer itemNum) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        String itemId = itemNum == null ? null : clientId + ':' + itemNum;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", (UIComponent)uiComponent);
        if (itemId != null) {
            writer.writeAttribute("id", (Object)itemId, null);
        }
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (renderId) {
            writer.writeAttribute("id", (Object)clientId, null);
        }
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_STYLE);
        if (this.isDisabled(facesContext, (UIComponent)uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        writer.endElement("input");
        return itemId;
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)uiComponent).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UIInput) {
            HtmlRendererUtils.decodeUISelectOne(facesContext, uiComponent);
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UISelectOne.class);
        return RendererUtils.getConvertedUISelectOneValue(facesContext, (UISelectOne)uiComponent, submittedValue);
    }
}

