/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.util.servlet;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SourceCodeServlet
extends HttpServlet {
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String webPage = req.getServletPath();
        int chopPoint = webPage.lastIndexOf(".source");
        if ((webPage = webPage.substring(0, chopPoint)).endsWith(".jsf")) {
            int jsfChopPoint = webPage.lastIndexOf(".jsf");
            webPage = webPage.substring(0, jsfChopPoint);
            webPage = webPage + ".jsp";
            String realPath = this.getServletConfig().getServletContext().getRealPath(webPage);
            this.outputFile(res, realPath);
        } else if (webPage.endsWith(".jsp")) {
            String realPath = this.getServletConfig().getServletContext().getRealPath(webPage);
            this.outputFile(res, realPath);
        } else if (webPage.endsWith(".jspx")) {
            String realPath = this.getServletConfig().getServletContext().getRealPath(webPage);
            this.outputFile(res, realPath);
        } else if (webPage.endsWith(".xhtml")) {
            String realPath = this.getServletConfig().getServletContext().getRealPath(webPage);
            this.outputFile(res, realPath);
        } else {
            int beginChopPoint = webPage.lastIndexOf("/");
            int extensionChopPoint = webPage.lastIndexOf(".java");
            webPage = webPage.substring(beginChopPoint + 1, extensionChopPoint);
            try {
                String realPath = this.getServletConfig().getServletContext().getRealPath("/WEB-INF/classes/" + webPage.replace('.', '/') + ".java");
                this.outputFile(res, realPath);
            }
            catch (Exception e) {
                String realPath = this.getServletConfig().getServletContext().getRealPath("/WEB-INF/src/" + webPage.replace('.', '/') + ".java");
                this.outputFile(res, realPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputFile(HttpServletResponse res, String realPath) throws IOException {
        res.setContentType("text/plain");
        ServletOutputStream out = res.getOutputStream();
        InputStream in = null;
        try {
            int ch;
            in = new BufferedInputStream(new FileInputStream(realPath));
            while ((ch = in.read()) != -1) {
                out.print((char)ch);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

