/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.stylesheet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;

public class TextResourceFilter
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)TextResourceFilter.class);
    private static final String CONTEXT_KEY = TextResourceFilter.class.getName() + ".INSTANCE";
    private final Map filteredResources = Collections.synchronizedMap(new TreeMap());

    protected TextResourceFilter() {
    }

    protected static TextResourceFilter create() {
        return new TextResourceFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextResourceFilter getInstance(ServletContext context) {
        Class clazz = TextResourceFilter.class;
        synchronized (clazz) {
            TextResourceFilter filterText = (TextResourceFilter)context.getAttribute(CONTEXT_KEY);
            if (filterText == null) {
                filterText = TextResourceFilter.create();
                context.setAttribute(CONTEXT_KEY, (Object)filterText);
            }
            return filterText;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextResourceFilter getInstance(FacesContext context) {
        Map appMap = context.getExternalContext().getApplicationMap();
        Class clazz = TextResourceFilter.class;
        synchronized (clazz) {
            TextResourceFilter filterText = (TextResourceFilter)appMap.get(CONTEXT_KEY);
            if (filterText == null) {
                filterText = TextResourceFilter.create();
                appMap.put(CONTEXT_KEY, filterText);
            }
            return filterText;
        }
    }

    public ResourceInfo getFilteredResource(String path) {
        ResourceInfo filteredResource = (ResourceInfo)this.filteredResources.get(path);
        if (filteredResource == null) {
            return null;
        }
        return filteredResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceInfo getOrCreateFilteredResource(FacesContext context, String path) throws IOException {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path must start with a slash, but was: " + path);
        }
        ResourceInfo filteredResource = this.getFilteredResource(path);
        if (filteredResource != null) {
            return filteredResource;
        }
        String text = RendererUtils.loadResourceFile(context, path);
        if (text == null) {
            text = "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new StringReader(text.toString()));
            while ((line = reader.readLine()) != null) {
                int pos = line.indexOf("#{");
                if (pos > -1 && line.indexOf("}", pos) > -1) {
                    line = RendererUtils.getStringValue(context, context.getApplication().createValueBinding(line));
                }
                if (line == null) continue;
                writer.println(line);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            writer.close();
        }
        filteredResource = new ResourceInfo(System.currentTimeMillis(), stringWriter.toString());
        this.filteredResources.put(path, filteredResource);
        return filteredResource;
    }

    public static class ResourceInfo {
        private final long lastModified;
        private final String text;

        protected ResourceInfo(long lastModified, String text) {
            this.lastModified = lastModified;
            this.text = text;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public String getText() {
            return this.text;
        }

        public int getSize() {
            return this.text.length();
        }
    }
}

