/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.selectOneCountry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectOne;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.component.html.ext.HtmlSelectOneMenu;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;

public abstract class AbstractSelectOneCountry
extends HtmlSelectOneMenu {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.SelectOneCountry";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.SelectOneCountryRenderer";

    public AbstractSelectOneCountry() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public abstract Integer getMaxLength();

    public abstract String getEmptySelection();

    private Set getFilterSet() {
        List selectItems = RendererUtils.getSelectItemList((UISelectOne)this);
        HashSet<String> set = new HashSet<String>(selectItems.size());
        Iterator i = selectItems.iterator();
        while (i.hasNext()) {
            set.add(((SelectItem)i.next()).getValue().toString().toUpperCase());
        }
        return set;
    }

    protected List getCountriesChoicesAsSelectItemList() {
        Integer maxLength;
        int maxDescriptionLength;
        Set filterSet = this.getFilterSet();
        String[] availableCountries = Locale.getISOCountries();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale currentLocale = viewRoot != null ? viewRoot.getLocale() : facesContext.getApplication().getDefaultLocale();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < availableCountries.length; ++i) {
            String countryCode = availableCountries[i];
            if (!filterSet.isEmpty() && !filterSet.contains(countryCode)) continue;
            Locale tmp = new Locale(countryCode, countryCode);
            map.put(tmp.getDisplayCountry(currentLocale), countryCode);
        }
        ArrayList<SelectItem> countriesSelectItems = new ArrayList<SelectItem>(map.size());
        if (this.getEmptySelection() != null) {
            countriesSelectItems.add(new SelectItem((Object)"", this.getEmptySelection()));
        }
        int n = maxDescriptionLength = (maxLength = this.getMaxLength()) == null ? Integer.MAX_VALUE : maxLength;
        if (maxDescriptionLength < 5) {
            maxDescriptionLength = 5;
        }
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String countryName = (String)i.next();
            String countryCode = (String)map.get(countryName);
            String label = countryName.length() <= maxDescriptionLength ? countryName : countryName.substring(0, maxDescriptionLength - 3) + "...";
            countriesSelectItems.add(new SelectItem((Object)countryCode, label));
        }
        return countriesSelectItems;
    }

    protected void validateValue(FacesContext context, Object value) {
        UISelectItems selectItems = new UISelectItems();
        selectItems.setTransient(true);
        selectItems.setValue((Object)this.getCountriesChoicesAsSelectItemList());
        this.getChildren().add(selectItems);
        super.validateValue(context, value);
    }
}

