/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.fileupload;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import org.apache.myfaces.component.AlignProperty;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.apache.myfaces.shared_tomahawk.util.MessageUtils;

public abstract class AbstractHtmlInputFileUpload
extends HtmlInputText
implements UserRoleAware,
AlignProperty {
    private static final String SIZE_LIMIT_EXCEEDED = "sizeLimitExceeded";
    private static final String FILE_SIZE_LIMIT_EXCEEDED = "fileSizeLimitExceeded";
    private static final String FILEUPLOAD_MAX_SIZE = "org.apache.myfaces.custom.fileupload.maxSize";
    private static final String FILEUPLOAD_EXCEPTION = "org.apache.myfaces.custom.fileupload.exception";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlInputFileUpload";
    public static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.FileUpload";
    public static final String SIZE_LIMIT_MESSAGE_ID = "org.apache.myfaces.FileUpload.SIZE_LIMIT";

    public AbstractHtmlInputFileUpload() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public void setUploadedFile(UploadedFile upFile) {
        this.setValue(upFile);
    }

    public UploadedFile getUploadedFile() {
        return (UploadedFile)this.getValue();
    }

    public abstract String getStorage();

    public abstract String getAccept();

    public Object getValue() {
        return super.getValue();
    }

    public boolean isRendered() {
        if (!UserRoleUtils.isVisibleOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    protected void validateValue(FacesContext context, Object convertedValue) {
        String exception;
        super.validateValue(context, convertedValue);
        if (this.isValid() && (exception = (String)context.getExternalContext().getRequestMap().get(FILEUPLOAD_EXCEPTION)) != null) {
            if (exception.equals(SIZE_LIMIT_EXCEEDED)) {
                Integer maxSize = (Integer)context.getExternalContext().getRequestMap().get(FILEUPLOAD_MAX_SIZE);
                MessageUtils.addMessage("org.apache.myfaces.tomahawk.Messages", FacesMessage.SEVERITY_ERROR, SIZE_LIMIT_MESSAGE_ID, new Object[]{this.getId(), maxSize}, this.getClientId(context), context);
                this.setValid(false);
            } else if (FILE_SIZE_LIMIT_EXCEEDED.equals(exception)) {
                Integer maxSize = (Integer)context.getExternalContext().getRequestMap().get(FILEUPLOAD_MAX_SIZE);
                if (maxSize != null) {
                    MessageUtils.addMessage("org.apache.myfaces.tomahawk.Messages", FacesMessage.SEVERITY_ERROR, SIZE_LIMIT_MESSAGE_ID, new Object[]{this.getId(), maxSize}, this.getClientId(context), context);
                } else {
                    maxSize = (Integer)context.getExternalContext().getRequestMap().get("org.apache.myfaces.custom.fileupload." + this.getClientId(context) + ".maxSize");
                    if (maxSize != null) {
                        MessageUtils.addMessage("org.apache.myfaces.tomahawk.Messages", FacesMessage.SEVERITY_ERROR, SIZE_LIMIT_MESSAGE_ID, new Object[]{this.getId(), maxSize}, this.getClientId(context), context);
                    }
                }
                this.setValid(false);
            } else {
                throw new IllegalStateException("other exceptions not handled yet, exception : " + exception);
            }
        }
    }
}

