/* Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package org.apache.myfaces.portlet.faces.testsuite.tests.chapter_4.section_4_2_5;

import javax.portlet.ActionResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;

import org.apache.myfaces.portlet.faces.testsuite.annotation.BridgeTest;
import org.apache.myfaces.portlet.faces.testsuite.beans.TestRunnerBean;
import org.apache.myfaces.portlet.faces.testsuite.common.Constants;

public class Tests
  extends Object
{
  @BridgeTest(test = "requestProcessingNonFacesTest")
  public String requestProcessingNonFacesTest(TestRunnerBean testRunner)
  {
    if (BridgeUtil.getPortletRequestPhase() ==
        Bridge.PortletPhase.ACTION_PHASE)
    {
      return "requestProcessingNonFacesTest"; // action Navigation result
    }
    else
    {
      // Note: Shouldn't get this far, it's a non-Faces request.
      return Constants.TEST_FAILED;
    }
  }
}
