@echo off

if "%TCK_TEST_FILE%"=="" (
  if "%TCK_CONFIG_HOME%"=="" (
    echo Test definition file not found.  Either set TCK_TEST_FILE to point to a test definition file or set TCK_CONFIG_HOME to point to a directory with a test definition file called test.xml in it.
    goto:eof
  )
  if not exist "%TCK_CONFIG_HOME%"\test.xml  (
    echo Test definition file not found
    goto:eof
  )
  set TCK_TEST_FILE=%TCK_CONFIG_HOME%\test.xml
)

if "%TCK_LOGIN_FILE%"=="" (
  rem Look for login.properties in TCK HOME dir
  if "%TCK_CONFIG_HOME%"=="" (
    echo Login properties file not found
    goto:eof
  )
  if not exist "%TCK_CONFIG_HOME%"\login.properties  (
    echo Login properties file not found
    goto:eof
  )
  set TCK_LOGIN_FILE=%TCK_CONFIG_HOME%\login.properties
)

if "%TCK_CLIENT_HOST%"=="" (
  echo TCK_CLIENT_HOST environment variable must be set
  goto:eof
)

if "%TCK_CLIENT_PORT%"=="" (
  echo TCK_CLIENT_PORT environment variable must be set
  goto:eof
)

echo TCK properties
echo --------------
echo Test definition file location: %TCK_TEST_FILE%
echo Login properties file: %TCK_LOGIN_FILE%
echo Client host: %TCK_CLIENT_HOST%
echo Client port: %TCK_CLIENT_PORT%


mvn clean surefire-report:report -Dtck.external-server=run-test -Dbridge.tck.test.file=%TCK_TEST_FILE% -Dbridge.tck.test.host=%TCK_CLIENT_HOST% -Dbridge.tck.test.port=%TCK_CLIENT_PORT% -Dbridge.tck.login-file=%TCK_LOGIN_FILE%
  

