/*
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.apache.myfaces.portlet.faces.testsuite.common.util;

import org.apache.myfaces.portlet.faces.testsuite.common.Constants;
import org.apache.myfaces.portlet.faces.testsuite.common.util.tags.TCKSpanTag;

/**
 * This class provides a way to put test results calculated in
 * portlets/servlets in the HTTP response body
 * These test results are delimited by portlet custom tags.
 */
public class BridgeTCKResultWriter {

    static public boolean PASS = true;
    static public boolean FAIL = false;

    static private String LINE_BREAK="<p>";

    private String mTestName = null;
    private TCKSpanTag mTestNameTag;
    private TCKSpanTag mDetailTag;
    private TCKSpanTag mStatusTag;


    /**
     * Constructor
     * 
     * @param testName name of the test
     */
    public BridgeTCKResultWriter(String testName) {
      super();
      mTestName = testName;
      mTestNameTag = new TCKSpanTag(mTestName + "-test-name");
      mTestNameTag.setTagContent(mTestName);                                                      
      mStatusTag = new TCKSpanTag(mTestName + "-result-status");
      mDetailTag = new TCKSpanTag(mTestName + "-result-detail");
    }

    /**
     * Sets the success/failure status for the test.
     * 
     * @param status
     */
    public void setStatus(boolean status) {
        mStatusTag.setTagContent(getStatusString(status));
    }

    /**
     * Let's the tests add details about the test run.
     * 
     * @param detailLine line containing detail information about the test run.
     */
    public void addDetail(String detailLine) {
        mDetailTag.appendTagContent(LINE_BREAK + detailLine );
    }
    
  public String getDetail()
  {
    return mDetailTag.toString();
  }
    
  /**
   * Let's the tests add details about the test run.
   * 
   * @param detailLine line containing detail information about the test run.
   */
  public void setDetail(String detailLine) {
      mDetailTag.appendTagContent(detailLine );
  }
    /**
     * Returns the string to be embedded in the Http Response.
     */

    public String toString() {
        mDetailTag.appendTagContent(LINE_BREAK);
        return  "Test: " + mTestNameTag.toString() + LINE_BREAK + "Status: "+ mStatusTag.toString() + LINE_BREAK + "Detail: " + mDetailTag.toString();
    }

    /**
     * Returns the string stating the status of the test.
     * 
     * @param status
     */
    private String getStatusString(boolean status) {
        if (status) {
            return getPassedString(mTestName);
        }
        else {
            return getFailedString(mTestName);
        }
    }

    /**
     * Returns the fail string. Also used on the client side to
     * provide failure critieria for a test.
     * 
     * @param testName
     */
    static public String getFailedString(String testName) {
        return Constants.TEST_FAILED; 
    }

    /**
     * Returns the pass string. Also used on the client side, for 
     * specifying the success criteria.
     * 
     * @param testName
     */
    static public String getPassedString(String testName) {

      return Constants.TEST_SUCCESS; 
    }

}
