/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNode;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.Selectable;
import org.apache.myfaces.tobago.model.SelectedState;
import org.apache.myfaces.tobago.model.TreePath;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.CustomAttributes;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeRenderer<T extends AbstractUITree>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String SCROLL_POSITION = "scrollPosition";

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        String value = (String)facesContext.getExternalContext().getRequestParameterMap().get(component.getClientId(facesContext) + "::scrollPosition");
        if (value != null) {
            ((AbstractUITree)component).getState().getScrollPosition().update(value);
        }
        RenderUtils.decodedStateOfTreeData(facesContext, component);
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeChildrenInternal(FacesContext facesContext, T component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof AbstractUIStyle)) continue;
            child.encodeAll(facesContext);
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        Markup markup = component.getMarkup();
        AbstractUITreeNode root = ComponentUtils.findDescendant(component, AbstractUITreeNode.class);
        if (root == null) {
            LOG.error("Can't find the tree root. This may occur while updating a tree from Tobago 1.0 to 1.5. Please refer the documentation to see how to use tree tags.");
            return;
        }
        this.insideBegin(facesContext, HtmlElements.TOBAGO_TREE);
        writer.startElement(HtmlElements.TOBAGO_TREE);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(component.getCustomClass());
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        Selectable selectable = ((AbstractUIData)component).getSelectable();
        if (selectable.isSupportedByTree()) {
            writer.writeAttribute(DataAttributes.SELECTABLE, selectable.name(), false);
            writer.writeAttribute(CustomAttributes.SELECTABLE, selectable.name(), false);
        }
        SelectedState selectedState = ((AbstractUITree)component).getSelectedState();
        ArrayList<Integer> selectedValue = new ArrayList<Integer>();
        ExpandedState expandedState = ((AbstractUITree)component).getExpandedState();
        ArrayList<Integer> expandedValue = new ArrayList<Integer>();
        int last = ((AbstractUIData)component).isRowsUnlimited() ? Integer.MAX_VALUE : component.getFirst() + component.getRows();
        for (int rowIndex = component.getFirst(); rowIndex < last; ++rowIndex) {
            component.setRowIndex(rowIndex);
            if (!component.isRowAvailable()) break;
            TreePath path = ((AbstractUIData)component).getPath();
            if (selectedState.isSelected(path)) {
                selectedValue.add(rowIndex);
            }
            if (((AbstractUIData)component).isFolder() && expandedState.isExpanded(path)) {
                expandedValue.add(rowIndex);
            }
            for (UIComponent child : component.getChildren()) {
                if (child instanceof AbstractUIStyle) continue;
                child.encodeAll(facesContext);
            }
        }
        component.setRowIndex(-1);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        String selectedId = clientId + "::selected";
        writer.writeNameAttribute(selectedId);
        writer.writeIdAttribute(selectedId);
        writer.writeClassAttribute(TobagoClass.SELECTED);
        writer.writeAttribute(HtmlAttributes.VALUE, JsonUtils.encode(selectedValue), false);
        writer.endElement(HtmlElements.INPUT);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        String expandedId = clientId + "::expanded";
        writer.writeNameAttribute(expandedId);
        writer.writeIdAttribute(expandedId);
        writer.writeClassAttribute(TobagoClass.EXPANDED);
        writer.writeAttribute(HtmlAttributes.VALUE, JsonUtils.encode(expandedValue), false);
        writer.endElement(HtmlElements.INPUT);
        writer.startElement(HtmlElements.TOBAGO_SCROLL);
        writer.startElement(HtmlElements.INPUT);
        writer.writeIdAttribute(clientId + "::scrollPosition");
        writer.writeNameAttribute(clientId + "::scrollPosition");
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeAttribute(HtmlAttributes.VALUE, ((AbstractUITree)component).getState().getScrollPosition().encode(), false);
        writer.writeAttribute(DataAttributes.SCROLL_POSITION, Boolean.TRUE.toString(), false);
        writer.endElement(HtmlElements.INPUT);
        writer.endElement(HtmlElements.TOBAGO_SCROLL);
        writer.endElement(HtmlElements.TOBAGO_TREE);
        this.insideEnd(facesContext, HtmlElements.TOBAGO_TREE);
    }
}

