// ---------- Attention: Generated code, please do not modify! -----------

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.component;

import jakarta.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectItems;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.component.Tags;
import jakarta.annotation.Generated;
import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;

/**
 Add a child UISelectItems component to the UIComponent
  associated with the closed parent UIComponent custom
  action.
  * UIComponent class, generated from template {@code component.stg} with class
  * {@link org.apache.myfaces.tobago.internal.taglib.component.SelectItemsTagDeclaration}.
 */
@Generated("component.stg")
public class UISelectItems
    extends AbstractUISelectItems  {

  private static final Tags TAG = Tags.selectItems;

  public static final String COMPONENT_TYPE = TAG.componentType();

  public static final String COMPONENT_FAMILY = "";


  enum PropertyKeys {
    itemDisabled,
    var,
    itemValue,
    tip,
    itemLabel,
    itemImage,
  }

  public String getFamily() {
    return COMPONENT_FAMILY;
  }


  /**
  Flag indicating whether the option created
   by this component is disabled.
  <br>Default: <code>false</code>
  */
  public boolean isItemDisabled() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.itemDisabled);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setItemDisabled(boolean itemDisabled) {
    getStateHelper().put(PropertyKeys.itemDisabled, itemDisabled);
  }

  /**
  Name of a variable under which the iterated data will be exposed.
   It may be referred to in EL of other attributes.

  */
  public java.lang.String getVar() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.var);
  }

  public void setVar(java.lang.String var) {
    getStateHelper().put(PropertyKeys.var, var);
  }

  /**
  Value to be returned to the server if this option is selected by the user.

  */
  public java.lang.Object getItemValue() {
    return getStateHelper().eval(PropertyKeys.itemValue);
  }

  public void setItemValue(java.lang.Object itemValue) {
    getStateHelper().put(PropertyKeys.itemValue, itemValue);
  }

  /**
  Text value to display as tooltip.

  */
  public java.lang.String getTip() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.tip);
  }

  public void setTip(java.lang.String tip) {
    getStateHelper().put(PropertyKeys.tip, tip);
  }

  /**
  Label to be displayed to the user for this option.

  */
  public java.lang.String getItemLabel() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.itemLabel);
  }

  public void setItemLabel(java.lang.String itemLabel) {
    getStateHelper().put(PropertyKeys.itemLabel, itemLabel);
  }

  /**
  Image to be displayed to the user for this option.

  */
  public java.lang.String getItemImage() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.itemImage);
  }

  public void setItemImage(java.lang.String itemImage) {
    getStateHelper().put(PropertyKeys.itemImage, itemImage);
  }


  @Override
  public void restoreState(FacesContext context, Object state) {
    // FIXME HACK for mojarra SystemEventListener state restoring bug
    pushComponentToEL(context, this);
    super.restoreState(context, state);
    popComponentFromEL(context);
  }

}