/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.validator;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.event.PhaseId;
import java.lang.invoke.MethodHandles;
import java.util.StringTokenizer;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearValidatorsActionListener
implements ActionListener {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PhaseId getPhaseId() {
        return PhaseId.APPLY_REQUEST_VALUES;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("actionEvent = '" + actionEvent + "'");
        }
        UIComponent source = actionEvent.getComponent();
        String clearValidatorsFieldIds = (String)ComponentUtils.findParameter(source, "clearValidatorsFieldIds");
        if (LOG.isDebugEnabled()) {
            LOG.debug("clearValidatorsFieldIds = '" + clearValidatorsFieldIds + "'");
        }
        StringTokenizer tokenizer = new StringTokenizer(clearValidatorsFieldIds, ",");
        while (tokenizer.hasMoreTokens()) {
            String clearValidatorsFieldId = tokenizer.nextToken();
            UIComponent component = source.findComponent(clearValidatorsFieldId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("component = '" + component + "'");
            }
            if (component == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Component not found locally, asking the tree.");
                }
                FacesContext facesContext = FacesContext.getCurrentInstance();
                component = facesContext.getViewRoot().findComponent(clearValidatorsFieldId);
            }
            if (component == null) {
                LOG.warn("Component not found.");
                continue;
            }
            LOG.error("NO LONGER AVAILABLE: component.clearValidators();");
        }
    }
}

