/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.convert;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import java.lang.invoke.MethodHandles;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Theme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeConverter
implements Converter<Theme> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String CONVERTER_ID = "org.apache.myfaces.tobago.Theme";

    public String getAsString(FacesContext facesContext, UIComponent component, Theme theme) throws ConverterException {
        try {
            return theme.getName();
        }
        catch (ClassCastException e) {
            throw new ConverterException("object='" + theme + "'", (Throwable)e);
        }
    }

    public Theme getAsObject(FacesContext facesContext, UIComponent component, String string) throws ConverterException {
        try {
            return TobagoConfig.getInstance(facesContext).getTheme(string);
        }
        catch (Exception e) {
            LOG.error("string='" + string + "'", (Throwable)e);
            throw new ConverterException("string='" + string + "'", (Throwable)e);
        }
    }
}

