/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.tobago.context.TobagoContext;
import org.apache.myfaces.tobago.context.UserAgent;
import org.apache.myfaces.tobago.internal.config.ContentSecurityPolicy;
import org.apache.myfaces.tobago.internal.context.Nonce;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private ResponseUtils() {
    }

    public static void ensureNoCacheHeader(FacesContext facesContext) {
        Object response = facesContext.getExternalContext().getResponse();
        if (response instanceof HttpServletResponse) {
            ResponseUtils.ensureNoCacheHeader((HttpServletResponse)response);
        }
    }

    public static void ensureNoCacheHeader(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache,no-store,max-age=0,must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setDateHeader("max-age", 0L);
    }

    public static void ensureContentTypeHeader(FacesContext facesContext, String contentType) {
        Object response = facesContext.getExternalContext().getResponse();
        if (response instanceof HttpServletResponse) {
            ResponseUtils.ensureContentTypeHeader((HttpServletResponse)response, contentType);
        }
    }

    public static void ensureContentTypeHeader(HttpServletResponse response, String contentType) {
        if (!response.containsHeader("Content-Type")) {
            response.setContentType(contentType);
        } else {
            String responseContentType = response.getContentType();
            if (!StringUtils.equalsIgnoreCaseAndWhitespace(responseContentType, contentType)) {
                response.setContentType(contentType);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response already contains Header Content-Type '" + responseContentType + "'. Overwriting with '" + contentType + "'");
                }
            }
        }
    }

    public static void ensureContentSecurityPolicyHeader(FacesContext facesContext, ContentSecurityPolicy contentSecurityPolicy) {
        Object response = facesContext.getExternalContext().getResponse();
        if (response instanceof HttpServletResponse) {
            String[] cspHeaders;
            HttpServletResponse servletResponse = (HttpServletResponse)response;
            TobagoContext tobagoContext = TobagoContext.getInstance(facesContext);
            UserAgent userAgent = tobagoContext.getUserAgent();
            switch (contentSecurityPolicy.getMode()) {
                case OFF: {
                    cspHeaders = new String[]{};
                    break;
                }
                case ON: {
                    cspHeaders = userAgent.getCspHeaders();
                    break;
                }
                case REPORT_ONLY: {
                    cspHeaders = userAgent.getCspReportOnlyHeaders();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Undefined mode: " + (Object)((Object)contentSecurityPolicy.getMode()));
                }
            }
            StringBuilder builder = new StringBuilder();
            String nonce = Nonce.getNonce(facesContext);
            for (Map.Entry<String, String> directive : contentSecurityPolicy.getDirectiveMap().entrySet()) {
                builder.append(directive.getKey());
                builder.append(" ");
                builder.append(directive.getValue().replace("${nonce}", nonce));
                builder.append(";");
            }
            for (String cspHeader : cspHeaders) {
                servletResponse.setHeader(cspHeader, builder.toString());
            }
        }
    }

    public static void ensureNosniffHeader(FacesContext facesContext) {
        Object response = facesContext.getExternalContext().getResponse();
        if (response instanceof HttpServletResponse) {
            HttpServletResponse servletResponse = (HttpServletResponse)response;
            ResponseUtils.ensureNosniffHeader(servletResponse);
        }
    }

    public static void ensureNosniffHeader(HttpServletResponse servletResponse) {
        servletResponse.setHeader("X-Content-Type-Options", "nosniff");
    }

    public static void ensureXFrameOptionsHeader(FacesContext facesContext) {
        Object response = facesContext.getExternalContext().getResponse();
        if (response instanceof HttpServletResponse) {
            ((HttpServletResponse)response).setHeader("X-Frame-Options", "DENY");
        }
    }
}

