/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.TobagoMessageBundle;
import org.apache.myfaces.tobago.context.TobagoResourceBundle;
import org.apache.myfaces.tobago.context.UserAgent;
import org.apache.myfaces.tobago.internal.util.CookieUtils;
import org.apache.myfaces.tobago.util.VariableResolverUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedBean
@RequestScoped
public class TobagoContext
implements Serializable {
    public static final String BEAN_NAME = "tobagoContext";
    private static final Logger LOG = LoggerFactory.getLogger(TobagoContext.class);
    @Deprecated
    private static final TobagoResourceBundle RESOURCE_BUNDLE = new TobagoResourceBundle();
    @Deprecated
    private static final TobagoMessageBundle MESSAGE_BUNDLE = new TobagoMessageBundle();
    private Theme theme;
    private UserAgent userAgent;
    private String focusId;
    private String enctype;

    public TobagoResourceBundle getResourceBundle() {
        return RESOURCE_BUNDLE;
    }

    public TobagoMessageBundle getMessageBundle() {
        return MESSAGE_BUNDLE;
    }

    public TobagoConfig getTobagoConfig() {
        return TobagoConfig.getInstance(FacesContext.getCurrentInstance());
    }

    public Theme getTheme() {
        if (this.theme == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            Object request = externalContext.getRequest();
            String themeName = request instanceof HttpServletRequest ? CookieUtils.getThemeNameFromCookie((HttpServletRequest)request) : null;
            this.theme = this.getTobagoConfig().getTheme(themeName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("theme='{}'", (Object)this.theme.getName());
            }
        }
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public UserAgent getUserAgent() {
        if (this.userAgent == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            String requestUserAgent = (String)externalContext.getRequestHeaderMap().get("User-Agent");
            this.userAgent = UserAgent.getInstance(requestUserAgent);
            if (LOG.isDebugEnabled()) {
                LOG.debug("userAgent='" + this.userAgent + "' from header 'User-Agent: " + requestUserAgent + "'");
            }
        }
        return this.userAgent;
    }

    public void setUserAgent(UserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public String getFocusId() {
        return this.focusId;
    }

    public void setFocusId(String focusId) {
        this.focusId = focusId;
    }

    public String getEnctype() {
        return this.enctype;
    }

    public void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    public static TobagoContext getInstance(FacesContext facesContext) {
        return (TobagoContext)VariableResolverUtils.resolveVariable(facesContext, BEAN_NAME);
    }
}

