/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.internal.config.TobagoConfigFragment;
import org.apache.myfaces.tobago.internal.config.TobagoConfigImpl;
import org.apache.myfaces.tobago.sanitizer.IgnoringSanitizer;
import org.apache.myfaces.tobago.sanitizer.JsoupSanitizer;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TobagoConfigMerger {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<TobagoConfigFragment> list;

    public TobagoConfigMerger(List<TobagoConfigFragment> list) {
        this.list = list;
    }

    public TobagoConfigImpl merge() {
        TobagoConfigImpl result = new TobagoConfigImpl();
        String sanitizerClass = JsoupSanitizer.class.getName();
        Properties sanitizerProperties = new Properties();
        sanitizerProperties.setProperty("safelist", "relaxed");
        for (TobagoConfigFragment fragment : this.list) {
            String defaultTheme = fragment.getDefaultThemeName();
            if (defaultTheme != null) {
                result.setDefaultThemeName(defaultTheme);
            }
            for (String supported : fragment.getSupportedThemeNames()) {
                result.addSupportedThemeName(supported);
            }
            if (fragment.getCreateSessionSecret() != null) {
                result.setCreateSessionSecret(fragment.getCreateSessionSecret());
            }
            if (fragment.getCheckSessionSecret() != null) {
                result.setCheckSessionSecret(fragment.getCheckSessionSecret());
            }
            if (fragment.getPreventFrameAttacks() != null) {
                result.setPreventFrameAttacks(fragment.getPreventFrameAttacks());
            }
            if (fragment.getContentSecurityPolicy() != null) {
                result.getContentSecurityPolicy().merge(fragment.getContentSecurityPolicy());
            }
            if (fragment.getSecurityAnnotation() != null) {
                result.setSecurityAnnotation(fragment.getSecurityAnnotation());
            }
            if (fragment.getSetNosniffHeader() != null) {
                result.setSetNosniffHeader(fragment.getSetNosniffHeader());
            }
            if (fragment.getSanitizerClass() != null) {
                sanitizerClass = fragment.getSanitizerClass();
                sanitizerProperties = fragment.getSanitizerProperties();
            }
            if (fragment.getDecodeLineFeed() != null) {
                result.setDecodeLineFeed(fragment.getDecodeLineFeed());
            }
            for (ThemeImpl theme : fragment.getThemeDefinitions()) {
                result.addAvailableTheme(theme);
            }
            Map<String, String> mimeTypes = result.getMimeTypes();
            for (Map.Entry<String, String> entry : fragment.getMimeTypes().entrySet()) {
                mimeTypes.put(entry.getKey(), entry.getValue());
            }
        }
        this.resolveThemes(result, result.getAvailableThemes());
        if (sanitizerClass != null) {
            try {
                Class<Sanitizer> aClass = Class.forName(sanitizerClass).asSubclass(Sanitizer.class);
                Sanitizer sanitizer = aClass.newInstance();
                sanitizer.setProperties(sanitizerProperties);
                result.setSanitizer(sanitizer);
            }
            catch (Exception e) {
                LOG.error("Can't create sanitizer: '" + sanitizerClass + "'", (Throwable)e);
                result.setSanitizer(new IgnoringSanitizer());
            }
        }
        return result;
    }

    private void resolveThemes(TobagoConfigImpl tobagoConfig, Map<String, ThemeImpl> map) {
        for (ThemeImpl theme : map.values()) {
            String fallbackName = theme.getFallbackName();
            ThemeImpl fallback = map.get(fallbackName);
            theme.setFallback(fallback);
        }
        for (ThemeImpl theme : map.values()) {
            theme.resolveFallbacks();
        }
        for (ThemeImpl theme : map.values()) {
            theme.resolveResources();
        }
        for (ThemeImpl theme : map.values()) {
            theme.init();
        }
    }
}

