/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.component.UIBox;
import org.apache.myfaces.tobago.component.UIMenuBar;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.BoxRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class BoxRenderer
extends BoxRendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UIMenuBar menuBar;
        UIBox box = (UIBox)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        UIComponent label = box.getFacet("label");
        String labelString = box.getLabel();
        UIPanel toolbar = (UIPanel)box.getFacet("toolBar");
        Style style = new Style(facesContext, (LayoutBase)box);
        if (toolbar != null) {
            Measure padding = this.getResourceManager().getThemeMeasure(facesContext, (Configurable)box, "paddingTopWhenToolbar");
            style.setPaddingTop(padding);
            style.setPaddingBottom(Measure.ZERO);
        }
        writer.startElement("fieldset", (UIComponent)box);
        writer.writeClassAttribute(Classes.create((UIComponent)box));
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)box);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)box);
        writer.writeStyleAttribute(style);
        if (label != null || labelString != null) {
            writer.startElement("legend", (UIComponent)box);
            writer.writeClassAttribute(Classes.create((UIComponent)box, (String)"legend"));
            if (label != null) {
                RenderUtils.encode(facesContext, label);
            } else {
                writer.writeText(labelString);
            }
            writer.endElement("legend");
        }
        Style contentStyle = new Style(facesContext, (LayoutBase)box);
        if (toolbar != null) {
            writer.startElement("div", null);
            writer.writeClassAttribute(Classes.create((UIComponent)box, (String)"toolbarOuter"));
            writer.startElement("div", null);
            writer.writeClassAttribute(Classes.create((UIComponent)box, (String)"toolbarInner"));
            toolbar.setRendererType("BoxToolBar");
            RenderUtils.encode(facesContext, (UIComponent)toolbar);
            writer.endElement("div");
            writer.endElement("div");
            if (ClientProperties.getInstance((FacesContext)facesContext).getUserAgent().isMsie()) {
                contentStyle.setTop(Measure.valueOf((int)-10));
            }
        }
        if ((menuBar = (UIMenuBar)ComponentUtils.findFacetDescendant((UIComponent)box, (String)"menuBar", UIMenuBar.class)) != null) {
            RenderUtils.encode(facesContext, (UIComponent)menuBar);
        }
        writer.startElement("div", (UIComponent)box);
        writer.writeClassAttribute(Classes.create((UIComponent)box, (String)"content"));
        Measure borderLeft = this.getBorderLeft(facesContext, (Configurable)box);
        Measure borderRight = this.getBorderRight(facesContext, (Configurable)box);
        Measure borderTop = this.getBorderTop(facesContext, (Configurable)box);
        Measure borderBottom = this.getBorderBottom(facesContext, (Configurable)box);
        contentStyle.setWidth(contentStyle.getWidth().subtract(borderLeft).subtract(borderRight));
        contentStyle.setHeight(contentStyle.getHeight().subtract(borderTop).subtract(borderBottom));
        contentStyle.setLeft(borderLeft);
        contentStyle.setTop(borderTop);
        writer.writeStyleAttribute(contentStyle);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("div");
        writer.endElement("fieldset");
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }
}

