/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;

public class MockResponseWriter
extends ResponseWriter {
    private String characterEncoding = null;
    private String contentType = "text/html";
    private boolean open = false;
    private UIComponent component;
    private Writer writer = null;

    public MockResponseWriter(Writer writer) {
        this.writer = writer;
        this.contentType = "text/html";
        this.characterEncoding = "UTF-8";
    }

    public MockResponseWriter(Writer writer, String contentType, String characterEncoding) {
        this.writer = writer;
        this.contentType = contentType;
        this.characterEncoding = characterEncoding;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new MockResponseWriter(writer, this.contentType, this.characterEncoding);
    }

    public void endDocument() throws IOException {
        this.finish();
        this.writer.flush();
    }

    public void endElement(String name) throws IOException {
        if (this.open) {
            this.writer.write("/");
            this.finish();
        } else {
            this.writer.write("</");
            this.writer.write(name);
            this.writer.write(">");
        }
        this.component = null;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void flush() throws IOException {
        this.finish();
    }

    public void startDocument() throws IOException {
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        this.finish();
        this.writer.write(60);
        this.writer.write(name);
        this.open = true;
        this.component = component;
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.open) {
            throw new IllegalStateException();
        }
        String attribute = this.findValue(value, property);
        if (attribute != null) {
            this.writer.write(" ");
            this.writer.write(name);
            this.writer.write("=\"");
            this.string(attribute);
            this.writer.write("\"");
        }
    }

    public void writeComment(Object comment) throws IOException {
        if (comment == null) {
            throw new NullPointerException();
        }
        this.finish();
        this.writer.write("<!-- ");
        if (comment instanceof String) {
            this.writer.write((String)comment);
        } else {
            this.writer.write(comment.toString());
        }
        this.writer.write(" -->");
    }

    public void writeText(Object text, String property) throws IOException {
        if (text == null) {
            throw new NullPointerException();
        }
        this.finish();
        String value = this.findValue(text, property);
        if (value != null) {
            this.string(value);
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (text == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > text.length || len < 0 || len > text.length) {
            throw new IndexOutOfBoundsException();
        }
        this.finish();
        this.string(text, off, len);
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.open) {
            throw new IllegalStateException();
        }
        String attribute = this.findValue(value, property);
        if (attribute != null) {
            this.writer.write(" ");
            this.writer.write(name);
            this.writer.write("=\"");
            this.string(attribute);
            this.writer.write("\"");
        }
    }

    public void close() throws IOException {
        this.finish();
        this.writer.close();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.finish();
        this.writer.write(cbuf, off, len);
    }

    private void character(char ch) throws IOException {
        if (ch <= '\u00ff') {
            if (ch == '\"') {
                this.writer.write("&quot;");
            } else if (ch == '&') {
                this.writer.write("&amp;");
            } else if (ch == '\'') {
                this.writer.write("&apos;");
            } else if (ch == '<') {
                this.writer.write("&lt;");
            } else if (ch == '>') {
                this.writer.write("&gt;");
            } else {
                this.writer.write(ch);
            }
        } else if (this.substitution()) {
            this.numeric(this.writer, ch);
        } else {
            this.writer.write(ch);
        }
    }

    private void finish() throws IOException {
        if (this.open) {
            this.writer.write(">");
            this.open = false;
        }
    }

    private void numeric(Writer writer, char ch) throws IOException {
        writer.write("&#");
        writer.write(String.valueOf(ch));
        writer.write(";");
    }

    private void string(char[] text, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.character(text[i]);
        }
    }

    private void string(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.character(s.charAt(i));
        }
    }

    private boolean substitution() {
        return !"UTF-8".equals(this.characterEncoding) && !"UTF-16".equals(this.characterEncoding);
    }

    private String findValue(Object value, String property) {
        if (value != null) {
            return value instanceof String ? (String)value : value.toString();
        }
        if (property != null && this.component != null) {
            Object object = this.component.getAttributes().get(property);
            if (object != null) {
                return object instanceof String ? (String)object : object.toString();
            }
            return null;
        }
        return null;
    }
}

