/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.viewController;

/**
 * Invokes ViewController events using the {@link ViewController} interface.
 * <p>
 * This requires that beans implement the ViewController interface in order
 * to receive view lifecycle events.
 * <p>
 * Other implementations are possible that do not require a bean to implement a
 * specific interface; see ReflectiveViewControllerExecutor for one example.
 * <p>
 * Note that each method here returns false if the target bean does not
 * implement the ViewController interface; this allows this executor to 
 * be "chained" with others.
 */
public class InterfaceViewControllerExecutor extends AbstractViewControllerExecutor
{
    public boolean invokeInitView(String beanName, Object bean)
    {
        if (bean instanceof ViewController)
        {
            ((ViewController) bean).initView();
            return true;
        }
        return false;
    }

    public boolean invokePreRenderView(String beanName, Object bean)
    {
        if (bean instanceof ViewController)
        {
            ((ViewController) bean).preRenderView();
            return true;
        }
        return false;
    }

    public boolean invokePreProcess(String beanName, Object bean)
    {
        if (bean instanceof ViewController)
        {
            ((ViewController) bean).preProcess();
            return true;
        }
        return false;
    }
}