/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.validation.strategy;

import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.CustomInformation;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.factory.AbstractNameMapperAwareFactory;
import org.apache.myfaces.extensions.validator.core.factory.ClassMappingFactory;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfiguration;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfigurationEntry;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfigurationNames;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticResourceBundleConfiguration;
import org.apache.myfaces.extensions.validator.core.mapper.NameMapper;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.NullValueAwareConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL, UsageCategory.CUSTOMIZABLE})
public class DefaultValidationStrategyFactory
extends AbstractNameMapperAwareFactory<String>
implements ClassMappingFactory<String, ValidationStrategy> {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private Map<String, String> metaDataKeyToValidationStrategyMapping = null;
    private List<NameMapper<String>> nameMapperList = new CopyOnWriteArrayList<NameMapper<String>>();

    public DefaultValidationStrategyFactory() {
        this.logger.fine(this.getClass().getName() + " instantiated");
    }

    @Override
    public ValidationStrategy create(String metaDataKey) {
        if (this.metaDataKeyToValidationStrategyMapping == null) {
            this.initStaticMappings();
        }
        if (this.metaDataKeyToValidationStrategyMapping.containsKey(metaDataKey)) {
            return this.getValidationStrategyInstance(this.metaDataKeyToValidationStrategyMapping.get(metaDataKey));
        }
        for (NameMapper<String> nameMapper : this.nameMapperList) {
            ValidationStrategy validationStrategy;
            String strategyName = nameMapper.createName(metaDataKey);
            if (strategyName == null || (validationStrategy = this.getValidationStrategyInstance(strategyName)) == null) continue;
            this.addMapping(metaDataKey, strategyName);
            return validationStrategy;
        }
        this.addMapping(metaDataKey, null);
        return null;
    }

    private ValidationStrategy getValidationStrategyInstance(String validationStrategyName) {
        if (validationStrategyName == null) {
            return null;
        }
        if (validationStrategyName.startsWith("bean:")) {
            return (ValidationStrategy)ExtValUtils.getELHelper().getBean(validationStrategyName.substring("bean:".length()));
        }
        return (ValidationStrategy)ClassUtils.tryToInstantiateClassForName(validationStrategyName);
    }

    private synchronized void addMapping(String metaDataKey, String validationStrategyName) {
        this.logger.finest("adding meta-data key to validation strategy mapping: " + metaDataKey + " -> " + validationStrategyName);
        this.metaDataKeyToValidationStrategyMapping.put(metaDataKey, validationStrategyName);
    }

    @ToDo(value=Priority.MEDIUM, description="logging")
    private synchronized void initStaticMappings() {
        this.metaDataKeyToValidationStrategyMapping = new NullValueAwareConcurrentHashMap<String, String>(String.class);
        for (StaticConfiguration<String, String> staticConfig : ExtValContext.getContext().getStaticConfiguration(StaticConfigurationNames.META_DATA_TO_VALIDATION_STRATEGY_CONFIG)) {
            this.setupStrategyMappings(staticConfig.getMapping());
        }
        StaticResourceBundleConfiguration staticConfig = new StaticResourceBundleConfiguration();
        try {
            staticConfig.setSourceOfMapping(ExtValContext.getContext().getInformationProviderBean().get(CustomInformation.STATIC_STRATEGY_MAPPING_SOURCE));
            this.setupStrategyMappings(staticConfig.getMapping());
        }
        catch (Exception e) {
            // empty catch block
        }
        String customMappingBaseName = ExtValCoreConfiguration.get().customStaticValidationStrategyMappingSource();
        if (customMappingBaseName != null) {
            try {
                staticConfig = new StaticResourceBundleConfiguration();
                staticConfig.setSourceOfMapping(customMappingBaseName);
                this.setupStrategyMappings(staticConfig.getMapping());
            }
            catch (MissingResourceException e) {
                e.printStackTrace();
            }
        }
    }

    private void setupStrategyMappings(List<StaticConfigurationEntry<String, String>> mappings) {
        for (StaticConfigurationEntry<String, String> mapping : mappings) {
            this.addMapping(mapping.getSource(), mapping.getTarget());
        }
    }

    @Override
    protected List<NameMapper<String>> getNameMapperList() {
        return this.nameMapperList;
    }
}

