/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.validation.message.resolver;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.CustomInformation;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.el.ELHelper;
import org.apache.myfaces.extensions.validator.core.validation.message.resolver.MessageResolver;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

@UsageInformation(value={UsageCategory.INTERNAL, UsageCategory.CUSTOMIZABLE})
public abstract class AbstractValidationErrorMessageResolver
implements MessageResolver {
    public static final String MISSING_RESOURCE_MARKER = "???";
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private static boolean deactivateDefaultConvention = ExtValCoreConfiguration.get().deactivateDefaultConvention();
    private static ResourceBundle defaultBundle = null;
    private String messageBundleBaseName;
    private String messageBundleVarName;
    private ELHelper elHelper = ExtValUtils.getELHelper();

    protected AbstractValidationErrorMessageResolver() {
        this.logger.fine(this.getClass().getName() + " instantiated");
    }

    public String getMessage(String key, Locale locale) {
        if (key == null || key.equals("")) {
            return null;
        }
        if (key.contains(" ")) {
            if (key.endsWith("_detail")) {
                key = key.substring(0, key.length() - 7);
            }
            return key;
        }
        String customMessage = null;
        try {
            customMessage = this.tryToFindCustomMessage(key, locale);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (customMessage != null) {
            return customMessage;
        }
        try {
            customMessage = this.tryToUseMessageBundleConvention(key, locale);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (customMessage != null) {
            return customMessage;
        }
        try {
            customMessage = this.tryToFindCustomMessageInCustomResourceBundle(key, locale);
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.determineMessage(key, locale, customMessage);
    }

    private String tryToFindCustomMessage(String key, Locale locale) {
        ResourceBundle resourceBundle;
        String customMessage = null;
        if (this.messageBundleBaseName != null) {
            resourceBundle = ResourceBundle.getBundle(this.messageBundleBaseName, locale);
            if (resourceBundle != null) {
                customMessage = resourceBundle.getString(key);
            } else {
                this.logger.warning("message bundle " + this.messageBundleBaseName + " not found");
            }
        }
        if (this.messageBundleVarName != null && customMessage == null) {
            resourceBundle = (ResourceBundle)this.elHelper.getBean(this.messageBundleVarName);
            if (resourceBundle != null) {
                customMessage = resourceBundle.getString(key);
            } else {
                this.logger.warning("message bundle var name " + this.messageBundleVarName + " not found");
            }
        }
        return customMessage;
    }

    private String tryToUseMessageBundleConvention(String key, Locale locale) {
        if (!deactivateDefaultConvention && this.isDefaultMessageBundleConventionActive()) {
            if (defaultBundle == null) {
                try {
                    defaultBundle = ResourceBundle.getBundle(ExtValContext.getContext().getInformationProviderBean().get(CustomInformation.MESSAGE_BUNDLE_NAME), locale);
                }
                catch (Exception e) {
                    deactivateDefaultConvention = true;
                }
            }
            if (defaultBundle != null) {
                return defaultBundle.getString(key);
            }
        }
        return null;
    }

    private String tryToFindCustomMessageInCustomResourceBundle(String key, Locale locale) {
        ResourceBundle resourceBundle = this.tryToLoadCustomResourceBundle(locale);
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                this.logger.log(Level.FINEST, "no custom message for " + key + " within " + this.getCustomBaseName(), e);
            }
        }
        return null;
    }

    private ResourceBundle tryToLoadCustomResourceBundle(Locale locale) {
        String customBaseName = this.getCustomBaseName();
        if (customBaseName != null) {
            return ResourceBundle.getBundle(customBaseName, locale);
        }
        return null;
    }

    private String determineMessage(String key, Locale locale, String customMessage) {
        try {
            return customMessage != null ? customMessage : (this.getBaseName() != null ? ResourceBundle.getBundle(this.getBaseName(), locale).getString(key) : null);
        }
        catch (MissingResourceException e) {
            return MISSING_RESOURCE_MARKER + key + MISSING_RESOURCE_MARKER;
        }
    }

    protected boolean isDefaultMessageBundleConventionActive() {
        return true;
    }

    protected abstract String getBaseName();

    protected String getCustomBaseName() {
        return null;
    }

    public void setMessageBundleBaseName(String messageBundleBaseName) {
        this.messageBundleBaseName = messageBundleBaseName;
    }

    public void setMessageBundleVarName(String messageBundleVarName) {
        this.messageBundleVarName = messageBundleVarName;
    }
}

