/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.storage;

import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.core.storage.MappedConstraintSourceStorage;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.NullValueAwareConcurrentHashMap;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultMappedConstraintSourceStorage
implements MappedConstraintSourceStorage {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private Map<String, Map<String, PropertyDetails>> propertyDetailsMap = new ConcurrentHashMap<String, Map<String, PropertyDetails>>();

    @Override
    public void storeMapping(Class originalClass, String originalProperty, PropertyDetails targetPropertyDetails) {
        if (targetPropertyDetails == null) {
            if (this.isFilteredClass(originalClass)) {
                return;
            }
            Map<String, PropertyDetails> classMap = this.getMapForClass(originalClass);
            classMap.put(originalProperty, null);
            return;
        }
        PropertyDetails propertyDetails = new PropertyDetails(targetPropertyDetails.getKey(), targetPropertyDetails.getBaseObject(), targetPropertyDetails.getProperty());
        this.getMapForClass(originalClass).put(originalProperty, propertyDetails);
    }

    protected boolean isFilteredClass(Class originalClass) {
        return ResourceBundle.class.isAssignableFrom(originalClass);
    }

    @Override
    public PropertyDetails getMappedConstraintSource(Class originalClass, String originalProperty) {
        if (this.isFilteredClass(originalClass)) {
            return null;
        }
        PropertyDetails foundEntry = this.getMapForClass(originalClass).get(originalProperty);
        if (foundEntry == null) {
            return null;
        }
        return new PropertyDetails(foundEntry.getKey(), foundEntry.getBaseObject(), foundEntry.getProperty());
    }

    @Override
    public boolean containsMapping(Class originalClass, String originalProperty) {
        if (this.isFilteredClass(originalClass)) {
            return true;
        }
        return this.getMapForClass(originalClass).containsKey(originalProperty);
    }

    private Map<String, PropertyDetails> getMapForClass(Class target) {
        String key = ProxyUtils.getClassName(target);
        if (!this.propertyDetailsMap.containsKey(key)) {
            this.propertyDetailsMap.put(key, new NullValueAwareConcurrentHashMap(this.createDefaultValue()));
        }
        return this.propertyDetailsMap.get(key);
    }

    private PropertyDetails createDefaultValue() {
        return new PropertyDetails(null, null, null);
    }
}

