/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.renderkit;

import javax.faces.render.RenderKit;
import org.apache.myfaces.extensions.validator.core.renderkit.AbstractRenderKitWrapperFactory;
import org.apache.myfaces.extensions.validator.core.renderkit.ExtValRenderKit;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultRenderKitWrapperFactory
extends AbstractRenderKitWrapperFactory {
    private RenderKit renderKit;
    private static final String GENERIC_RENDER_KIT_WRAPPER_FACTORY = "org.apache.myfaces.extensions.validator.generic.renderkit.GenericRenderKitWrapperFactory";
    private static Boolean useGenericRenderKitWrapperFactory = null;

    protected RenderKit createWrapper(RenderKit renderKit) {
        this.logger.finest("extval renderkit wrapper created for " + renderKit.getClass().getName());
        if (useGenericRenderKitWrapperFactory == null) {
            Class genericFactory = ClassUtils.tryToLoadClassForName(GENERIC_RENDER_KIT_WRAPPER_FACTORY);
            useGenericRenderKitWrapperFactory = genericFactory != null;
        }
        if (useGenericRenderKitWrapperFactory.booleanValue()) {
            AbstractRenderKitWrapperFactory renderKitWrapperFactory = (AbstractRenderKitWrapperFactory)ClassUtils.tryToInstantiateClassForName(GENERIC_RENDER_KIT_WRAPPER_FACTORY);
            return renderKitWrapperFactory.createWrapper(renderKit);
        }
        if (this.renderKit == null) {
            this.renderKit = new ExtValRenderKit(renderKit);
        }
        return this.renderKit;
    }
}

