/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.crossval.strategy;

import java.lang.annotation.Annotation;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorage;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorageEntry;
import org.apache.myfaces.extensions.validator.crossval.storage.ProcessedInformationStorage;
import org.apache.myfaces.extensions.validator.crossval.storage.ProcessedInformationStorageEntry;
import org.apache.myfaces.extensions.validator.crossval.strategy.AbstractCompareStrategy;
import org.apache.myfaces.extensions.validator.crossval.strategy.CrossValidationHelper;
import org.apache.myfaces.extensions.validator.crossval.strategy.LocalCompareStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.CrossValidationUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
class LocalPropertyChainCompareStrategy
extends LocalCompareStrategy {
    LocalPropertyChainCompareStrategy() {
    }

    public boolean evaluateReferenceAndValidate(CrossValidationStorageEntry crossValidationStorageEntry, CrossValidationStorage crossValidationStorage, String validationTarget, AbstractCompareStrategy compareStrategy) {
        if (!validationTarget.contains(".")) {
            return false;
        }
        return this.tryToValidateLocally(crossValidationStorageEntry, crossValidationStorage, validationTarget, compareStrategy);
    }

    protected boolean tryToValidateLocally(CrossValidationStorageEntry crossValidationStorageEntry, CrossValidationStorage crossValidationStorage, String targetKey, AbstractCompareStrategy compareStrategy) {
        String newKey;
        ProcessedInformationStorage processedInformationStorage = CrossValidationUtils.getOrInitProcessedInformationStorage();
        if (processedInformationStorage.containsEntry(newKey = this.createTargetKey(crossValidationStorageEntry, targetKey))) {
            ProcessedInformationStorageEntry validationTargetEntry = processedInformationStorage.getEntry(newKey);
            this.processCrossComponentValidation(compareStrategy, crossValidationStorageEntry, validationTargetEntry);
        } else {
            this.processModelAwareCrossValidation(compareStrategy, crossValidationStorageEntry, targetKey);
        }
        return true;
    }

    private void processCrossComponentValidation(AbstractCompareStrategy compareStrategy, CrossValidationStorageEntry crossValidationStorageEntry, ProcessedInformationStorageEntry targetInformationEntry) {
        if (compareStrategy.isViolation(crossValidationStorageEntry.getConvertedObject(), targetInformationEntry.getConvertedValue(), (Annotation)crossValidationStorageEntry.getMetaDataEntry().getValue(Annotation.class))) {
            CrossValidationStorageEntry tmpCrossValidationStorageEntry = new CrossValidationStorageEntry();
            tmpCrossValidationStorageEntry.setComponent(crossValidationStorageEntry.getComponent());
            tmpCrossValidationStorageEntry.setClientId(targetInformationEntry.getClientId());
            tmpCrossValidationStorageEntry.setConvertedObject(targetInformationEntry.getConvertedValue());
            tmpCrossValidationStorageEntry.setValidationStrategy(compareStrategy);
            if (crossValidationStorageEntry.getComponent() != null) {
                compareStrategy.processTargetComponentAfterViolation(crossValidationStorageEntry, tmpCrossValidationStorageEntry);
            } else {
                compareStrategy.processTargetComponentAfterViolation(crossValidationStorageEntry, null);
            }
            compareStrategy.processSourceComponentAfterViolation(crossValidationStorageEntry);
        }
    }

    private void processModelAwareCrossValidation(AbstractCompareStrategy compareStrategy, CrossValidationStorageEntry crossValidationStorageEntry, String targetKey) {
        PropertyDetails propertyDetails = (PropertyDetails)crossValidationStorageEntry.getMetaDataEntry().getProperty("property_details", PropertyDetails.class);
        Object newBase = ReflectionUtils.getBaseOfPropertyChain((Object)propertyDetails.getBaseObject(), (String)targetKey);
        if (targetKey.contains(".")) {
            targetKey = targetKey.substring(targetKey.lastIndexOf(".") + 1, targetKey.length());
        }
        Object targetValue = this.getValueOfProperty(newBase, targetKey);
        ProcessedInformationStorageEntry targetEntry = new ProcessedInformationStorageEntry();
        targetEntry.setBean(newBase);
        targetEntry.setConvertedValue(targetValue);
        CrossValidationHelper.crossValidateCompareStrategy(compareStrategy, crossValidationStorageEntry, targetEntry, true);
    }
}

