/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.trinidad.interceptor;

import java.lang.reflect.Method;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.extensions.validator.core.InvocationOrder;
import org.apache.myfaces.extensions.validator.core.interceptor.ValidationExceptionInterceptor;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.validation.exception.RequiredValidatorException;
import org.apache.myfaces.extensions.validator.core.validation.message.LabeledMessage;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;
import org.apache.myfaces.trinidad.context.RequestContext;

@InvocationOrder(value=300)
@UsageInformation(value={UsageCategory.INTERNAL})
public class TrinidadValidationExceptionInterceptor
implements ValidationExceptionInterceptor {
    private static final String TRINIDAD_CORE_INPUT_TEXT = "org.apache.myfaces.trinidad.component.core.input.CoreInputText";
    private static final String TRINIDAD_CORE_INPUT_DATE = "org.apache.myfaces.trinidad.component.core.input.CoreInputDate";

    public boolean afterThrowing(UIComponent uiComponent, MetaDataEntry metaDataEntry, Object convertedObject, ValidatorException validatorException, ValidationStrategy validatorExceptionSource) {
        if (this.processComponent(uiComponent)) {
            this.tryToRefreshComponent(uiComponent);
            this.tryToPlaceLabelInFacesMessage(uiComponent, metaDataEntry, validatorException);
        }
        return true;
    }

    private void tryToPlaceLabelInFacesMessage(UIComponent uiComponent, MetaDataEntry metaDataEntry, ValidatorException validatorException) {
        this.tryToHandleRequiredValidatorException(uiComponent, validatorException);
        String label = this.detectLabelText(metaDataEntry, uiComponent);
        this.processLabel(validatorException.getFacesMessage(), label);
    }

    private String detectLabelText(MetaDataEntry metaDataEntry, UIComponent uiComponent) {
        String label = this.getLabel(uiComponent);
        label = this.getClientIdAsFallbackIfNeeded(uiComponent, label);
        label = this.tryToOverrideLabelIfProvidedManually(metaDataEntry, label);
        return label;
    }

    private void processLabel(FacesMessage facesMessage, String label) {
        if (facesMessage instanceof LabeledMessage) {
            ((LabeledMessage)facesMessage).setLabelText(label);
        } else {
            for (int i = 0; i < 3; ++i) {
                ExtValUtils.tryToPlaceLabel((FacesMessage)facesMessage, (String)label, (int)i);
            }
        }
    }

    private String tryToOverrideLabelIfProvidedManually(MetaDataEntry metaDataEntry, String label) {
        if (metaDataEntry != null && metaDataEntry.getProperty("label") != null) {
            return (String)metaDataEntry.getProperty("label", String.class);
        }
        return label;
    }

    private String getClientIdAsFallbackIfNeeded(UIComponent uiComponent, String label) {
        if (label == null) {
            return uiComponent.getClientId(FacesContext.getCurrentInstance());
        }
        return label;
    }

    private void tryToHandleRequiredValidatorException(UIComponent uiComponent, ValidatorException validatorException) {
        if (validatorException instanceof RequiredValidatorException) {
            FacesMessage facesMessage = validatorException.getFacesMessage();
            String inlineMessage = this.getInlineRequiredMessage(uiComponent);
            if (inlineMessage != null) {
                facesMessage.setSummary(inlineMessage);
                facesMessage.setDetail(inlineMessage);
            }
        }
    }

    private void tryToRefreshComponent(UIComponent uiComponent) {
        if (RequestContext.getCurrentInstance().isPartialRequest(FacesContext.getCurrentInstance())) {
            RequestContext.getCurrentInstance().addPartialTarget(uiComponent);
        }
    }

    protected boolean processComponent(UIComponent uiComponent) {
        return uiComponent != null && (TRINIDAD_CORE_INPUT_TEXT.equals(uiComponent.getClass().getName()) || TRINIDAD_CORE_INPUT_DATE.equals(uiComponent.getClass().getName()));
    }

    private String getLabel(UIComponent uiComponent) {
        return (String)ReflectionUtils.tryToInvokeMethod((Object)uiComponent, (Method)ReflectionUtils.tryToGetMethod(uiComponent.getClass(), (String)"getLabel"));
    }

    private String getInlineRequiredMessage(UIComponent uiComponent) {
        return (String)ReflectionUtils.tryToInvokeMethod((Object)uiComponent, (Method)ReflectionUtils.tryToGetMethod(uiComponent.getClass(), (String)"getRequiredMessageDetail"));
    }
}

