/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.util;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import javax.interceptor.InvocationContext;
import org.apache.myfaces.extensions.cdi.core.api.config.view.ViewConfig;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDecisionState;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDecisionVoter;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDecisionVoterContext;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDeniedException;
import org.apache.myfaces.extensions.cdi.core.api.security.SecurityViolation;
import org.apache.myfaces.extensions.cdi.core.impl.security.spi.EditableAccessDecisionVoterContext;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public abstract class SecurityUtils {
    private SecurityUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeVoters(InvocationContext invocationContext, BeanManager beanManager, AccessDecisionVoterContext voterContext, List<Class<? extends AccessDecisionVoter>> accessDecisionVoters, Class<? extends ViewConfig> errorView) {
        if (accessDecisionVoters == null) {
            return;
        }
        AccessDecisionState voterState = AccessDecisionState.VOTE_IN_PROGRESS;
        try {
            if (voterContext instanceof EditableAccessDecisionVoterContext) {
                ((EditableAccessDecisionVoterContext)voterContext).setState(voterState);
            }
            for (Class<? extends AccessDecisionVoter> voterClass : accessDecisionVoters) {
                AccessDecisionVoter voter = CodiUtils.getContextualReferenceByClass(beanManager, voterClass, new Annotation[0]);
                Set violations = voter.checkPermission(invocationContext);
                if (violations == null || violations.size() <= 0) continue;
                if (voterContext instanceof EditableAccessDecisionVoterContext) {
                    voterState = AccessDecisionState.VIOLATION_FOUND;
                    for (SecurityViolation securityViolation : violations) {
                        ((EditableAccessDecisionVoterContext)voterContext).addViolation(securityViolation);
                    }
                }
                throw new AccessDeniedException(violations, errorView);
            }
        }
        finally {
            if (voterContext instanceof EditableAccessDecisionVoterContext) {
                if (AccessDecisionState.VOTE_IN_PROGRESS.equals((Object)voterState)) {
                    voterState = AccessDecisionState.NO_VIOLATION_FOUND;
                }
                ((EditableAccessDecisionVoterContext)voterContext).setState(voterState);
            }
        }
    }
}

