/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.config.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Typed;
import org.apache.myfaces.extensions.cdi.core.api.config.view.DefaultErrorView;
import org.apache.myfaces.extensions.cdi.core.api.config.view.ViewConfig;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.ViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.InlineViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.EditableViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.ViewConfigExtractor;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public class ViewConfigCache {
    private static Map<ClassLoader, Map<String, ViewConfigDescriptor>> viewIdToViewDefinitionEntryMapping = new HashMap<ClassLoader, Map<String, ViewConfigDescriptor>>();
    private static Map<ClassLoader, Map<Class<? extends ViewConfig>, ViewConfigDescriptor>> viewDefinitionToViewDefinitionEntryMapping = new HashMap<ClassLoader, Map<Class<? extends ViewConfig>, ViewConfigDescriptor>>();
    private static Map<ClassLoader, List<InlineViewConfigDescriptor>> inlineViewDefinitionEntryList = new HashMap<ClassLoader, List<InlineViewConfigDescriptor>>();
    private static Map<ClassLoader, ViewConfigDescriptor> defaultErrorView = new HashMap<ClassLoader, ViewConfigDescriptor>();
    private static Map<ClassLoader, Class> inlineViewConfigRootMarker = new HashMap<ClassLoader, Class>();
    private static volatile Map<ClassLoader, Boolean> lazyInitAllowed = new HashMap<ClassLoader, Boolean>();

    private ViewConfigCache() {
    }

    static void activateWriteMode() {
        ViewConfigCache.setLazyInit(false);
    }

    static void deactivateWriteMode() {
        ViewConfigCache.setLazyInit(true);
    }

    private static void setLazyInit(boolean newValue) {
        lazyInitAllowed.put(ViewConfigCache.getClassloader(), newValue);
    }

    static void addViewConfigDescriptor(String viewId, ViewConfigDescriptor viewConfigDescriptor) {
        ViewConfigCache.storeViewConfigDescriptor(viewId, viewConfigDescriptor, false);
    }

    static void replaceViewConfigDescriptor(String viewId, ViewConfigDescriptor viewDefinitionEntry) {
        ViewConfigCache.storeViewConfigDescriptor(viewId, viewDefinitionEntry, true);
    }

    public static ViewConfigDescriptor getViewConfigDescriptor(String viewId) {
        return ViewConfigCache.getViewIdToViewDefinitionEntryMapping(true).get(viewId);
    }

    public static Collection<ViewConfigDescriptor> getViewConfigDescriptors() {
        Map<String, ViewConfigDescriptor> entryMap = ViewConfigCache.getViewIdToViewDefinitionEntryMapping(true);
        return entryMap.values();
    }

    public static ViewConfigDescriptor getViewConfigDescriptor(Class<? extends ViewConfig> viewDefinitionClass) {
        return ViewConfigCache.getViewDefinitionToViewDefinitionEntryMapping(true).get(viewDefinitionClass);
    }

    public static ViewConfigDescriptor getDefaultErrorViewConfigDescriptor() {
        ViewConfigCache.lazyInlineViewConfigCompilation();
        return defaultErrorView.get(ViewConfigCache.getClassloader());
    }

    public static void reset() {
        ViewConfigCache.getViewIdToViewDefinitionEntryMapping(false).clear();
        ViewConfigCache.getViewDefinitionToViewDefinitionEntryMapping(false).clear();
        ViewConfigCache.getInlineViewDefinitionToViewDefinitionEntryList().clear();
        defaultErrorView.put(ViewConfigCache.getClassloader(), null);
        inlineViewConfigRootMarker.put(ViewConfigCache.getClassloader(), null);
    }

    static void queueInlineViewConfig(ViewConfigExtractor viewConfigExtractor, Class<? extends ViewConfig> beanClass) {
        ViewConfigCache.getInlineViewDefinitionToViewDefinitionEntryList().add(new InlineViewConfigDescriptor(viewConfigExtractor, beanClass));
    }

    static void setInlineViewConfigRootMarker(Class viewConfigRootClass) {
        Class storedPageClass = ViewConfigCache.getInlineViewConfigRootMarker();
        if (storedPageClass != null) {
            if (!storedPageClass.equals(viewConfigRootClass)) {
                throw ExceptionUtils.ambiguousViewConfigRootException(storedPageClass, viewConfigRootClass);
            }
        } else {
            inlineViewConfigRootMarker.put(ViewConfigCache.getClassloader(), viewConfigRootClass);
        }
    }

    static Class getInlineViewConfigRootMarker() {
        return inlineViewConfigRootMarker.get(ViewConfigCache.getClassloader());
    }

    static void storeViewDefinition(String viewId, ViewConfigDescriptor viewDefinitionEntry, boolean allowReplace, boolean lazyInit) {
        if (ViewConfigCache.getViewIdToViewDefinitionEntryMapping(lazyInit).containsKey(viewId) && !allowReplace) {
            throw ExceptionUtils.ambiguousViewDefinitionException(viewId, viewDefinitionEntry.getViewConfig(), ViewConfigCache.getViewIdToViewDefinitionEntryMapping(lazyInit).get(viewId).getViewConfig());
        }
        ViewConfigCache.tryToStorePageAsDefaultErrorPage(viewDefinitionEntry);
        ViewConfigCache.getViewIdToViewDefinitionEntryMapping(lazyInit).put(viewId, viewDefinitionEntry);
        ViewConfigCache.getViewDefinitionToViewDefinitionEntryMapping(lazyInit).put(viewDefinitionEntry.getViewConfig(), viewDefinitionEntry);
    }

    static void storeViewConfigDescriptor(String viewId, ViewConfigDescriptor viewConfigDescriptor, boolean allowReplace) {
        ViewConfigCache.storeViewDefinition(viewId, viewConfigDescriptor, allowReplace, true);
    }

    private static Map<String, ViewConfigDescriptor> getViewIdToViewDefinitionEntryMapping(boolean lazyInit) {
        Map<String, ViewConfigDescriptor> result;
        if (lazyInit) {
            ViewConfigCache.lazyInlineViewConfigCompilation();
        }
        if ((result = viewIdToViewDefinitionEntryMapping.get(ViewConfigCache.getClassloader())) == null) {
            result = new HashMap<String, ViewConfigDescriptor>();
            viewIdToViewDefinitionEntryMapping.put(ViewConfigCache.getClassloader(), result);
        }
        return result;
    }

    private static Map<Class<? extends ViewConfig>, ViewConfigDescriptor> getViewDefinitionToViewDefinitionEntryMapping(boolean lazyInit) {
        Map<Class<? extends ViewConfig>, ViewConfigDescriptor> result;
        if (lazyInit) {
            ViewConfigCache.lazyInlineViewConfigCompilation();
        }
        if ((result = viewDefinitionToViewDefinitionEntryMapping.get(ViewConfigCache.getClassloader())) == null) {
            result = new HashMap<Class<? extends ViewConfig>, ViewConfigDescriptor>();
            viewDefinitionToViewDefinitionEntryMapping.put(ViewConfigCache.getClassloader(), result);
        }
        return result;
    }

    private static List<InlineViewConfigDescriptor> getInlineViewDefinitionToViewDefinitionEntryList() {
        List<InlineViewConfigDescriptor> inlineViewConfigDescriptors = inlineViewDefinitionEntryList.get(ViewConfigCache.getClassloader());
        if (inlineViewConfigDescriptors == null) {
            inlineViewConfigDescriptors = new ArrayList<InlineViewConfigDescriptor>();
            inlineViewDefinitionEntryList.put(ViewConfigCache.getClassloader(), inlineViewConfigDescriptors);
        }
        return inlineViewConfigDescriptors;
    }

    private static void tryToStorePageAsDefaultErrorPage(ViewConfigDescriptor viewDefinitionEntry) {
        if (DefaultErrorView.class.isAssignableFrom(viewDefinitionEntry.getViewConfig())) {
            ViewConfigDescriptor currentErrorView = ViewConfigCache.getDefaultErrorViewConfigDescriptor();
            if (currentErrorView != null) {
                throw ExceptionUtils.ambiguousDefaultErrorViewDefinitionException(viewDefinitionEntry.getViewConfig(), currentErrorView.getViewConfig());
            }
            ViewConfigCache.setDefaultErrorView(viewDefinitionEntry);
        }
    }

    private static void setDefaultErrorView(ViewConfigDescriptor viewDefinitionEntry) {
        defaultErrorView.put(ViewConfigCache.getClassloader(), viewDefinitionEntry);
    }

    private static ClassLoader getClassloader() {
        return ClassUtils.getClassLoader(null);
    }

    private static void lazyInlineViewConfigCompilation() {
        List<InlineViewConfigDescriptor> inlineViewConfigDescriptors = inlineViewDefinitionEntryList.get(ViewConfigCache.getClassloader());
        if (inlineViewConfigDescriptors == null) {
            return;
        }
        if (ViewConfigCache.isInWriteMode()) {
            return;
        }
        ViewConfigCache.registerInlineViewConfigDescriptor();
    }

    private static boolean isInWriteMode() {
        return !Boolean.TRUE.equals(lazyInitAllowed.get(ViewConfigCache.getClassloader()));
    }

    private static synchronized void registerInlineViewConfigDescriptor() {
        List<InlineViewConfigDescriptor> inlineViewConfigDescriptors = inlineViewDefinitionEntryList.get(ViewConfigCache.getClassloader());
        if (inlineViewConfigDescriptors == null) {
            return;
        }
        for (InlineViewConfigDescriptor inlineViewConfigDescriptor : inlineViewConfigDescriptors) {
            EditableViewConfigDescriptor viewConfig = inlineViewConfigDescriptor.getViewConfigExtractor().extractInlineViewConfig(inlineViewConfigDescriptor.getViewConfigDefinition());
            if (viewConfig == null) continue;
            viewConfig.addPageBean(viewConfig.getViewConfig());
            ViewConfigCache.storeViewDefinition(viewConfig.getViewId(), viewConfig, false, false);
        }
        inlineViewDefinitionEntryList.put(ViewConfigCache.getClassloader(), null);
    }
}

