/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import jakarta.faces.component.UICommand;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIParameter;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.html.HtmlCommandButton;
import jakarta.faces.component.html.HtmlCommandLink;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.core.api.shared.AttributeUtils;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.core.api.shared.lang.SharedStringBuilder;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlFormRendererBase;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonHtmlAttributesUtil;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;

public class HtmlButtonRendererBase
extends HtmlRenderer {
    private static final String SB_BUILD_BEHAVIORIZED_ONCLICK = HtmlButtonRendererBase.class.getName() + "#buildBehaviorizedOnClick";
    private static final String SB_BUILD_ONCLICK = HtmlButtonRendererBase.class.getName() + "#buildOnClick";
    private static final String SB_ADD_CHILD_PARAMETERS = HtmlButtonRendererBase.class.getName() + "#addChildParameters";
    private static final String IMAGE_BUTTON_SUFFIX_X = ".x";
    private static final String IMAGE_BUTTON_SUFFIX_Y = ".y";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        boolean activateActionEvent;
        RendererUtils.checkParamValidity(facesContext, uiComponent, UICommand.class);
        boolean disabled = this.isDisabled(facesContext, uiComponent);
        boolean bl = activateActionEvent = !HtmlButtonRendererBase.isReset(uiComponent) && HtmlButtonRendererBase.isSubmitted(facesContext, uiComponent) && !disabled;
        if (uiComponent instanceof ClientBehaviorHolder && !disabled) {
            ClientBehaviorRendererUtils.decodeClientBehaviors(facesContext, uiComponent);
        }
        if (activateActionEvent) {
            uiComponent.queueEvent(new ActionEvent(uiComponent));
        }
    }

    private static boolean isReset(UIComponent uiComponent) {
        return "reset".equals(uiComponent.getAttributes().get("type"));
    }

    private static boolean isButton(UIComponent uiComponent) {
        return "button".equals(uiComponent.getAttributes().get("type"));
    }

    private static boolean isSubmitted(FacesContext facesContext, UIComponent uiComponent) {
        String clientId = uiComponent.getClientId(facesContext);
        Map<String, String> paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String hiddenLink = null;
        UIForm form = ComponentUtils.findClosest(UIForm.class, uiComponent);
        if (form != null) {
            hiddenLink = facesContext.getExternalContext().getRequestParameterMap().get(HtmlRendererUtils.getHiddenCommandLinkFieldName(form, facesContext));
        }
        return paramMap.containsKey(clientId) || paramMap.containsKey(clientId + IMAGE_BUTTON_SUFFIX_X) || paramMap.containsKey(clientId + IMAGE_BUTTON_SUFFIX_Y) || hiddenLink != null && hiddenLink.equals(clientId) || HtmlRendererUtils.isPartialOrBehaviorSubmit(facesContext, clientId);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        CharSequence onClick;
        String commandOnclick;
        RendererUtils.checkParamValidity(facesContext, uiComponent, UICommand.class);
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        UIForm form = ComponentUtils.findClosest(UIForm.class, uiComponent);
        boolean reset = HtmlButtonRendererBase.isReset(uiComponent);
        boolean button = HtmlButtonRendererBase.isButton(uiComponent);
        Map<String, List<ClientBehavior>> behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)((Object)uiComponent)).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        List<UIParameter> validParams = HtmlRendererUtils.getValidUIParameterChildren(facesContext, this.getChildren(uiComponent), false, false);
        if (form != null && validParams != null && !validParams.isEmpty()) {
            HtmlRendererUtils.renderFormSubmitScript(facesContext);
        }
        if ((commandOnclick = (String)uiComponent.getAttributes().get("onclick")) != null && validParams != null && !validParams.isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", clientId, "id");
        writer.writeAttribute("name", clientId, "id");
        String image = RendererUtils.getIconSrc(facesContext, uiComponent, "image");
        if (image != null) {
            writer.writeAttribute("type", "image", "type");
            writer.writeURIAttribute("src", image, "image");
        } else {
            String type = this.getType(uiComponent);
            if (type == null || !reset && !button) {
                type = "submit";
            }
            writer.writeAttribute("type", type, "type");
            Object value = this.getValue(uiComponent);
            if (value != null) {
                writer.writeAttribute("value", value, "value");
            }
        }
        if (ClientBehaviorRendererUtils.hasClientBehavior("click", behaviors) || ClientBehaviorRendererUtils.hasClientBehavior("action", behaviors)) {
            if (!reset && !button) {
                onClick = this.buildBehaviorizedOnClick(uiComponent, behaviors, facesContext, writer, form, validParams);
                if (((String)onClick).length() != 0) {
                    writer.writeAttribute("onclick", onClick, null);
                }
            } else {
                Collection<ClientBehaviorContext.Parameter> paramList = ClientBehaviorRendererUtils.getClientBehaviorContextParameters(HtmlRendererUtils.mapAttachedParamsToStringValues(facesContext, uiComponent));
                String onClick2 = ClientBehaviorRendererUtils.buildBehaviorChain(facesContext, uiComponent, "click", paramList, "action", paramList, behaviors, commandOnclick, null);
                if (onClick2.length() != 0) {
                    writer.writeAttribute("onclick", onClick2, null);
                }
            }
            Map<String, Object> attributes = uiComponent.getAttributes();
            ClientBehaviorRendererUtils.buildBehaviorChain(facesContext, uiComponent, "dblclick", null, behaviors, (String)attributes.get("ondblclick"), "");
        } else if (!reset && !button) {
            onClick = this.buildOnClick(uiComponent, facesContext, writer, validParams);
            if (((StringBuilder)onClick).length() != 0) {
                writer.writeAttribute("onclick", ((StringBuilder)onClick).toString(), null);
            }
        } else {
            HtmlRendererUtils.renderHTMLStringAttribute(writer, uiComponent, "onclick", "onclick");
        }
        if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            CommonHtmlAttributesUtil.renderButtonPassthroughPropertiesWithoutDisabledAndEvents(writer, CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent), uiComponent);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.BUTTON_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
        }
        if (behaviors != null && !behaviors.isEmpty()) {
            HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderBehaviorizedFieldEventHandlers(facesContext, writer, uiComponent, behaviors);
        } else if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            long commonAttributesMarked = CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent);
            CommonHtmlAttributesUtil.renderEventPropertiesWithoutOnclick(writer, commonAttributesMarked, uiComponent);
            CommonHtmlAttributesUtil.renderCommonFieldEventProperties(writer, commonAttributesMarked, uiComponent);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.EVENT_HANDLER_ATTRIBUTES_WITHOUT_ONCLICK);
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_FIELD_EVENT_ATTRIBUTES);
        }
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", "disabled", "disabled");
        }
        if (this.isReadonly(facesContext, uiComponent)) {
            writer.writeAttribute("readonly", "readonly", "readonly");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("input");
        UIForm form = ComponentUtils.findClosest(UIForm.class, uiComponent);
        if (form != null) {
            HtmlFormRendererBase.renderScrollHiddenInputIfNecessary(form, facesContext, writer);
        }
    }

    protected String buildBehaviorizedOnClick(UIComponent uiComponent, Map<String, List<ClientBehavior>> behaviors, FacesContext facesContext, ResponseWriter writer, UIComponent form, List<UIParameter> validParams) throws IOException {
        StringBuilder sb = SharedStringBuilder.get(facesContext, SB_BUILD_BEHAVIORIZED_ONCLICK);
        String commandOnClick = (String)uiComponent.getAttributes().get("onclick");
        if (commandOnClick != null) {
            sb.append(commandOnClick);
            sb.append(';');
        }
        String userOnClick = sb.toString();
        sb.setLength(0);
        if (form != null && JavascriptUtils.isRenderClearJavascriptOnButton(facesContext.getExternalContext())) {
            HtmlRendererUtils.appendClearHiddenCommandFormParamsFunctionCall(sb, form.getClientId(facesContext));
        }
        Collection<ClientBehaviorContext.Parameter> paramList = ClientBehaviorRendererUtils.getClientBehaviorContextParameters(HtmlRendererUtils.mapAttachedParamsToStringValues(facesContext, uiComponent));
        return ClientBehaviorRendererUtils.buildBehaviorChain(facesContext, uiComponent, "click", paramList, "action", paramList, behaviors, userOnClick, sb.toString());
    }

    private StringBuilder addChildParameters(FacesContext context, List<UIParameter> validParams) {
        StringBuilder params = SharedStringBuilder.get(context, SB_ADD_CHILD_PARAMETERS);
        params.append('[');
        int size = validParams.size();
        for (int i = 0; i < size; ++i) {
            UIParameter param = validParams.get(i);
            String name = param.getName();
            Object value = param.getValue();
            String strParamValue = "";
            if (value != null) {
                strParamValue = value.toString();
                StringBuilder buff = null;
                for (int j = 0; j < strParamValue.length(); ++j) {
                    char c = strParamValue.charAt(j);
                    if (c == '\'' || c == '\\') {
                        if (buff == null) {
                            buff = new StringBuilder();
                            buff.append(strParamValue, 0, j);
                        }
                        buff.append('\\');
                        buff.append(c);
                        continue;
                    }
                    if (buff == null) continue;
                    buff.append(c);
                }
                if (buff != null) {
                    strParamValue = buff.toString();
                }
            }
            if (params.length() > 1) {
                params.append(',');
            }
            params.append("['");
            params.append(name);
            params.append("','");
            params.append(strParamValue);
            params.append("']");
        }
        params.append(']');
        return params;
    }

    private String getTarget(UIComponent component) {
        String target = component instanceof HtmlCommandLink ? ((HtmlCommandLink)component).getTarget() : (String)component.getAttributes().get("target");
        return target;
    }

    protected StringBuilder buildOnClick(UIComponent uiComponent, FacesContext facesContext, ResponseWriter writer, List<UIParameter> validParams) throws IOException {
        UIForm form;
        StringBuilder onClick = SharedStringBuilder.get(facesContext, SB_BUILD_ONCLICK);
        String commandOnClick = (String)uiComponent.getAttributes().get("onclick");
        if (commandOnClick != null) {
            onClick.append("var cf = function(){");
            onClick.append(commandOnClick);
            onClick.append('}');
            onClick.append(';');
            onClick.append("var oamSF = function(){");
        }
        if ((form = ComponentUtils.findClosest(UIForm.class, uiComponent)) != null) {
            if (validParams != null && !validParams.isEmpty()) {
                StringBuilder params = this.addChildParameters(facesContext, validParams);
                String target = this.getTarget(uiComponent);
                onClick.append("return ").append("myfaces.oam.submitForm").append("('").append(form.getClientId(facesContext)).append("','").append(uiComponent.getClientId(facesContext)).append('\'');
                if (params.length() > 2 || target != null) {
                    onClick.append(',').append((String)(target == null ? "null" : "'" + target + "'")).append(',').append((CharSequence)params);
                }
                onClick.append(");");
            } else if (JavascriptUtils.isRenderClearJavascriptOnButton(facesContext.getExternalContext())) {
                HtmlRendererUtils.appendClearHiddenCommandFormParamsFunctionCall(onClick, form.getClientId(facesContext));
            }
        }
        if (commandOnClick != null) {
            onClick.append('}');
            onClick.append(';');
            onClick.append("return (cf.apply(this, [])==false)? false : oamSF.apply(this, []); ");
        }
        return onClick;
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlCommandButton) {
            return ((HtmlCommandButton)uiComponent).isDisabled();
        }
        return AttributeUtils.getBooleanAttribute(uiComponent, "disabled", false);
    }

    protected boolean isReadonly(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlCommandButton) {
            return ((HtmlCommandButton)uiComponent).isReadonly();
        }
        return AttributeUtils.getBooleanAttribute(uiComponent, "readonly", false);
    }

    private String getType(UIComponent uiComponent) {
        if (uiComponent instanceof HtmlCommandButton) {
            return ((HtmlCommandButton)uiComponent).getType();
        }
        return (String)uiComponent.getAttributes().get("type");
    }

    private Object getValue(UIComponent uiComponent) {
        if (uiComponent instanceof ValueHolder) {
            return ((ValueHolder)((Object)uiComponent)).getValue();
        }
        return uiComponent.getAttributes().get("value");
    }
}

