/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view;

import jakarta.faces.view.ViewDeclarationLanguage;
import jakarta.faces.view.ViewDeclarationLanguageFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.myfaces.view.ViewDeclarationLanguageStrategy;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguageStrategy;

public class ViewDeclarationLanguageFactoryImpl
extends ViewDeclarationLanguageFactory {
    private volatile boolean _initialized = false;
    private volatile ViewDeclarationLanguageStrategy[] _supportedLanguages;
    private volatile List<ViewDeclarationLanguage> _supportedVDLs = null;

    @Override
    public ViewDeclarationLanguage getViewDeclarationLanguage(String viewId) {
        if (!this._initialized) {
            this.initialize();
        }
        for (ViewDeclarationLanguageStrategy strategy : this._supportedLanguages) {
            if (!strategy.handles(viewId)) continue;
            return strategy.getViewDeclarationLanguage();
        }
        return null;
    }

    @Override
    public List<ViewDeclarationLanguage> getAllViewDeclarationLanguages() {
        if (!this._initialized) {
            this.initialize();
        }
        if (this._supportedVDLs == null) {
            ArrayList<ViewDeclarationLanguage> list = new ArrayList<ViewDeclarationLanguage>(this._supportedLanguages.length);
            for (ViewDeclarationLanguageStrategy strategy : this._supportedLanguages) {
                list.add(strategy.getViewDeclarationLanguage());
            }
            this._supportedVDLs = Collections.unmodifiableList(list);
        }
        return this._supportedVDLs;
    }

    private synchronized void initialize() {
        if (!this._initialized) {
            this._supportedLanguages = new ViewDeclarationLanguageStrategy[]{new FaceletViewDeclarationLanguageStrategy()};
            this._initialized = true;
        }
    }
}

