/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import jakarta.faces.FacesException;
import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.FaceletHandler;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.myfaces.util.WebConfigParamUtils;
import org.apache.myfaces.util.lang.ArrayUtils;
import org.apache.myfaces.util.lang.StringUtils;
import org.apache.myfaces.view.facelets.tag.TagLibrary;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentResourceTagHandler;
import org.apache.myfaces.view.facelets.tag.composite.CompositeResouceWrapper;

public class CompositeResourceLibrary
implements TagLibrary {
    public static final String NAMESPACE_PREFIX = "jakarta.faces.composite/";
    public static final String JCP_NAMESPACE_PREFIX = "http://xmlns.jcp.org/jsf/composite/";
    public static final String SUN_NAMESPACE_PREFIX = "http://java.sun.com/jsf/composite/";
    private final ResourceHandler _resourceHandler;
    private Pattern _acceptPatterns;
    private String _extension;
    private String[] _defaultSuffixesArray;
    private String _namespacePrefix;

    public CompositeResourceLibrary(FacesContext facesContext, String namespacePrefix) {
        this._namespacePrefix = namespacePrefix;
        this._resourceHandler = facesContext.getApplication().getResourceHandler();
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        this._acceptPatterns = this.loadAcceptPattern(externalContext);
        this._extension = this.loadFaceletExtension(externalContext);
        String defaultSuffixes = WebConfigParamUtils.getStringInitParameter(externalContext, "jakarta.faces.DEFAULT_SUFFIX", ".xhtml");
        this._defaultSuffixesArray = StringUtils.splitShortString(defaultSuffixes, ' ');
        boolean faceletsExtensionFound = false;
        for (String ext : this._defaultSuffixesArray) {
            if (!this._extension.equals(ext)) continue;
            faceletsExtensionFound = true;
            break;
        }
        if (!faceletsExtensionFound) {
            this._defaultSuffixesArray = (String[])ArrayUtils.concat(this._defaultSuffixesArray, new String[]{this._extension});
        }
    }

    private Pattern loadAcceptPattern(ExternalContext context) {
        assert (context != null);
        String mappings = context.getInitParameter("jakarta.faces.FACELETS_VIEW_MAPPINGS");
        if (mappings == null) {
            return null;
        }
        if ((mappings = mappings.trim()).length() == 0) {
            return null;
        }
        return Pattern.compile(this.toRegex(mappings));
    }

    private String loadFaceletExtension(ExternalContext context) {
        assert (context != null);
        String suffix = context.getInitParameter("jakarta.faces.FACELETS_SUFFIX");
        if (suffix == null) {
            suffix = ".xhtml";
        } else if ((suffix = suffix.trim()).length() == 0) {
            suffix = ".xhtml";
        }
        return suffix;
    }

    private String toRegex(String mappings) {
        assert (mappings != null);
        mappings = mappings.replaceAll("\\s", "");
        mappings = mappings.replaceAll("\\.", "\\\\.");
        mappings = mappings.replaceAll("\\*", ".*");
        mappings = mappings.replaceAll(";", "|");
        return mappings;
    }

    public boolean handles(String resourceName) {
        if (resourceName == null) {
            return false;
        }
        if (resourceName.endsWith(this._extension)) {
            return true;
        }
        return this._acceptPatterns != null && this._acceptPatterns.matcher(resourceName).matches();
    }

    @Override
    public boolean containsFunction(String ns, String name) {
        return false;
    }

    @Override
    public boolean containsNamespace(String ns) {
        if (ns != null && ns.startsWith(this._namespacePrefix) && ns.length() > this._namespacePrefix.length()) {
            String libraryName = ns.substring(this._namespacePrefix.length());
            return this._resourceHandler.libraryExists(libraryName);
        }
        return false;
    }

    @Override
    public boolean containsTagHandler(String ns, String localName) {
        if (ns != null && ns.startsWith(this._namespacePrefix) && ns.length() > this._namespacePrefix.length()) {
            String libraryName = ns.substring(this._namespacePrefix.length());
            for (String defaultSuffix : this._defaultSuffixesArray) {
                Resource compositeComponentResource;
                String resourceName = localName + defaultSuffix;
                if (!this.handles(resourceName) || (compositeComponentResource = this._resourceHandler.createResource(resourceName, libraryName)) == null) continue;
                URL url = compositeComponentResource.getURL();
                return url != null;
            }
        }
        return false;
    }

    @Override
    public Method createFunction(String ns, String name) {
        return null;
    }

    @Override
    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        if (ns != null && ns.startsWith(this._namespacePrefix) && ns.length() > this._namespacePrefix.length()) {
            String libraryName = ns.substring(this._namespacePrefix.length());
            for (String defaultSuffix : this._defaultSuffixesArray) {
                Resource compositeComponentResourceWrapped;
                String resourceName = localName + defaultSuffix;
                if (!this.handles(resourceName) || (compositeComponentResourceWrapped = this._resourceHandler.createResource(resourceName, libraryName)) == null) continue;
                CompositeResouceWrapper compositeComponentResource = new CompositeResouceWrapper(compositeComponentResourceWrapped);
                ComponentConfigWrapper componentConfig = new ComponentConfigWrapper(tag, "jakarta.faces.NamingContainer", null);
                return new CompositeComponentResourceTagHandler(componentConfig, compositeComponentResource);
            }
        }
        return null;
    }

    private static class ComponentConfigWrapper
    implements ComponentConfig {
        protected final TagConfig parent;
        protected final String componentType;
        protected final String rendererType;

        public ComponentConfigWrapper(TagConfig parent, String componentType, String rendererType) {
            this.parent = parent;
            this.componentType = componentType;
            this.rendererType = rendererType;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public String getRendererType() {
            return this.rendererType;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }
}

