/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push.cdi;

import jakarta.faces.context.ExternalContext;
import jakarta.websocket.Session;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.apache.myfaces.push.WebsocketSessionClusterSerializedRestore;
import org.apache.myfaces.push.util.Json;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.ConcurrentLRUCache;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

public final class WebsocketApplicationSessionHolder {
    public static final String INIT_PARAM_WEBSOCKET_MAX_CONNECTIONS = "org.apache.myfaces.WEBSOCKET_MAX_CONNECTIONS";
    public static final Integer INIT_PARAM_WEBSOCKET_MAX_CONNECTIONS_DEFAULT = 5000;
    private static volatile WeakHashMap<ClassLoader, ConcurrentLRUCache<String, Reference<Session>>> clWebsocketMap = new WeakHashMap();
    private static volatile WeakHashMap<ClassLoader, Queue<String>> clWebsocketRestoredQueue = new WeakHashMap();
    private static final String WARNING_TOMCAT_WEB_SOCKET_BOMBED = "Tomcat cannot handle concurrent push messages. A push message has been sent only after %s retries. Consider rate limiting sending push messages. For example, once every 500ms.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConcurrentLRUCache<String, Reference<Session>> getWebsocketSessionLRUCache() {
        ClassLoader cl = ClassUtils.getContextClassLoader();
        ConcurrentLRUCache<String, Reference<Session>> metadata = clWebsocketMap.get(cl);
        if (metadata == null) {
            WeakHashMap<ClassLoader, ConcurrentLRUCache<String, Reference<Session>>> weakHashMap = clWebsocketMap;
            synchronized (weakHashMap) {
                metadata = WebsocketApplicationSessionHolder.createWebsocketSessionLRUCache(cl, metadata, INIT_PARAM_WEBSOCKET_MAX_CONNECTIONS_DEFAULT);
            }
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initWebsocketSessionLRUCache(ExternalContext context) {
        ClassLoader cl = ClassUtils.getContextClassLoader();
        ConcurrentLRUCache<String, Reference<Session>> lruCache = clWebsocketMap.get(cl);
        int size = WebConfigParamUtils.getIntegerInitParameter(context, INIT_PARAM_WEBSOCKET_MAX_CONNECTIONS, (int)INIT_PARAM_WEBSOCKET_MAX_CONNECTIONS_DEFAULT);
        ConcurrentLRUCache<String, Reference<Session>> newMetadata = new ConcurrentLRUCache<String, Reference<Session>>((size * 4 + 3) / 3, size);
        WeakHashMap<ClassLoader, ConcurrentLRUCache<String, Reference<Session>>> weakHashMap = clWebsocketMap;
        synchronized (weakHashMap) {
            if (lruCache == null) {
                clWebsocketMap.put(cl, newMetadata);
                lruCache = newMetadata;
            } else {
                for (Map.Entry<String, Reference<Session>> entry : lruCache.getLatestAccessedItems(INIT_PARAM_WEBSOCKET_MAX_CONNECTIONS_DEFAULT).entrySet()) {
                    if (entry.getValue() == null || entry.getValue().get() == null || !entry.getValue().get().isOpen()) continue;
                    newMetadata.put(entry.getKey(), entry.getValue());
                }
                clWebsocketMap.put(cl, newMetadata);
                lruCache = newMetadata;
            }
        }
    }

    private static ConcurrentLRUCache<String, Reference<Session>> createWebsocketSessionLRUCache(ClassLoader cl, ConcurrentLRUCache<String, Reference<Session>> metadata, int size) {
        metadata = clWebsocketMap.get(cl);
        if (metadata == null) {
            metadata = new ConcurrentLRUCache((size * 4 + 3) / 3, size);
            clWebsocketMap.put(cl, metadata);
        }
        return metadata;
    }

    public static void clearWebsocketSessionLRUCache() {
        clWebsocketMap.remove(ClassUtils.getContextClassLoader());
        clWebsocketRestoredQueue.remove(ClassUtils.getContextClassLoader());
    }

    public static boolean addOrUpdateSession(String channelToken, Session session) {
        Reference<Session> oldInstance = WebsocketApplicationSessionHolder.getWebsocketSessionLRUCache().get(channelToken);
        if (oldInstance == null) {
            WebsocketApplicationSessionHolder.getWebsocketSessionLRUCache().put(channelToken, new SoftReference<Session>(session));
        } else if (!session.equals(oldInstance.get())) {
            WebsocketApplicationSessionHolder.getWebsocketSessionLRUCache().put(channelToken, new SoftReference<Session>(session));
        }
        return true;
    }

    public static boolean removeSession(String channelToken) {
        WebsocketApplicationSessionHolder.getWebsocketSessionLRUCache().remove(channelToken);
        return false;
    }

    protected static Set<Future<Void>> send(String channelToken, Object message) {
        Reference<Session> sessionRef;
        WebsocketApplicationSessionHolder.synchronizeSessionInstances();
        HashSet<Future<Void>> results = new HashSet<Future<Void>>(1);
        Reference<Session> reference = sessionRef = channelToken != null ? WebsocketApplicationSessionHolder.getWebsocketSessionLRUCache().get(channelToken) : null;
        if (sessionRef != null && sessionRef.get() != null) {
            String json = Json.encode(message);
            Session session = sessionRef.get();
            if (session.isOpen()) {
                WebsocketApplicationSessionHolder.send(session, json, results, 0);
            } else {
                WebsocketApplicationSessionHolder.getWebsocketSessionLRUCache().remove(channelToken);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void send(Session session, String text, Set<Future<Void>> results, int retries) {
        try {
            results.add(session.getAsyncRemote().sendText(text));
            if (retries > 0) {
                Logger.getLogger(WebsocketApplicationSessionHolder.class.getName()).warning(String.format(WARNING_TOMCAT_WEB_SOCKET_BOMBED, retries));
            }
        }
        catch (IllegalStateException e) {
            if (WebsocketApplicationSessionHolder.isTomcatWebSocketBombed(session, e)) {
                Session session2 = session;
                synchronized (session2) {
                    WebsocketApplicationSessionHolder.send(session, text, results, retries + 1);
                }
            }
            throw e;
        }
    }

    private static boolean isTomcatWebSocketBombed(Session session, IllegalStateException illegalStateException) {
        return session.getClass().getName().startsWith("org.apache.tomcat.websocket.") && illegalStateException.getMessage().contains("[TEXT_FULL_WRITING]");
    }

    private static void synchronizeSessionInstances() {
        Session s;
        Reference<Session> ref;
        Map<String, Reference<Session>> map;
        Queue<String> queue = WebsocketApplicationSessionHolder.getRestoredQueue();
        if (!queue.isEmpty() && (map = WebsocketApplicationSessionHolder.getWebsocketSessionLRUCache().getLatestAccessedItems(1)) != null && !map.isEmpty() && (ref = map.values().iterator().next()) != null && (s = ref.get()) != null) {
            Set set = s.getOpenSessions();
            for (Session instance : set) {
                WebsocketSessionClusterSerializedRestore r = (WebsocketSessionClusterSerializedRestore)instance.getUserProperties().get("oam.websocket.SR");
                if (r == null || !r.isDeserialized()) continue;
                WebsocketApplicationSessionHolder.addOrUpdateSession(r.getChannelToken(), s);
            }
            queue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Queue<String> getRestoredQueue() {
        ClassLoader cl = ClassUtils.getContextClassLoader();
        Queue<String> metadata = clWebsocketRestoredQueue.get(cl);
        if (metadata == null) {
            WeakHashMap<ClassLoader, Queue<String>> weakHashMap = clWebsocketRestoredQueue;
            synchronized (weakHashMap) {
                metadata = WebsocketApplicationSessionHolder.createRestoredQueue(cl, metadata);
            }
        }
        return metadata;
    }

    private static Queue<String> createRestoredQueue(ClassLoader cl, Queue<String> metadata) {
        metadata = clWebsocketRestoredQueue.get(cl);
        if (metadata == null) {
            metadata = new ConcurrentLinkedQueue<String>();
            clWebsocketRestoredQueue.put(cl, metadata);
        }
        return metadata;
    }
}

