/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.faces.FacesException;
import jakarta.faces.application.Resource;
import jakarta.faces.application.ViewResource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.UniqueIdVendor;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.FaceletHandler;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.view.facelets.AbstractFacelet;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.compiler.EncodingHandler;
import org.apache.myfaces.view.facelets.impl.DefaultFaceletContext;
import org.apache.myfaces.view.facelets.impl.DefaultFaceletFactory;
import org.apache.myfaces.view.facelets.impl.FaceletCompositionContextImpl;
import org.apache.myfaces.view.facelets.impl.PageContextImpl;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;

final class DefaultFacelet
extends AbstractFacelet {
    private static final Logger log = Logger.getLogger(DefaultFacelet.class.getName());
    private static final String APPLIED_KEY = "org.apache.myfaces.view.facelets.APPLIED";
    private final String _alias;
    private final String _faceletId;
    private final ExpressionFactory _elFactory;
    private final DefaultFaceletFactory _factory;
    private final long _createTime;
    private final long _refreshPeriod;
    private final Map<String, URL> _relativePaths;
    private final FaceletHandler _root;
    private final URL _src;
    private final boolean _isBuildingCompositeComponentMetadata;
    private final boolean _encodingHandler;

    public DefaultFacelet(DefaultFaceletFactory factory, ExpressionFactory el, URL src, String alias, String faceletId, FaceletHandler root) {
        this._factory = factory;
        this._elFactory = el;
        this._src = src;
        this._root = root;
        this._alias = alias;
        this._faceletId = faceletId;
        this._createTime = System.currentTimeMillis();
        this._refreshPeriod = this._factory.getRefreshPeriod();
        this._relativePaths = Collections.synchronizedMap(new WeakHashMap());
        this._isBuildingCompositeComponentMetadata = false;
        this._encodingHandler = root instanceof EncodingHandler;
    }

    public DefaultFacelet(DefaultFaceletFactory factory, ExpressionFactory el, URL src, String alias, String faceletId, FaceletHandler root, boolean isBuildingCompositeComponentMetadata) {
        this._factory = factory;
        this._elFactory = el;
        this._src = src;
        this._root = root;
        this._alias = alias;
        this._faceletId = faceletId;
        this._createTime = System.currentTimeMillis();
        this._refreshPeriod = this._factory.getRefreshPeriod();
        this._relativePaths = Collections.synchronizedMap(new WeakHashMap());
        this._isBuildingCompositeComponentMetadata = isBuildingCompositeComponentMetadata;
        this._encodingHandler = root instanceof EncodingHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(FacesContext facesContext, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        FaceletCompositionContext myFaceletContext = null;
        boolean faceletCompositionContextInitialized = false;
        boolean recordUniqueIds = false;
        myFaceletContext = FaceletCompositionContext.getCurrentInstance(facesContext);
        if (myFaceletContext == null) {
            myFaceletContext = new FaceletCompositionContextImpl(this._factory, facesContext);
            myFaceletContext.init(facesContext);
            faceletCompositionContextInitialized = true;
            if (this._encodingHandler && !myFaceletContext.isBuildingViewMetadata() && MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isViewUniqueIdsCacheEnabled() && this._refreshPeriod <= 0L) {
                List<String> uniqueIdList = ((EncodingHandler)this._root).getUniqueIdList();
                if (uniqueIdList == null) {
                    myFaceletContext.initUniqueIdRecording();
                    recordUniqueIds = true;
                } else {
                    myFaceletContext.setUniqueIdsIterator(uniqueIdList.iterator());
                }
            }
            if (parent instanceof UIViewRoot) {
                myFaceletContext.setViewRoot((UIViewRoot)parent);
                ComponentSupport.setCachedFacesContext((UIViewRoot)parent, facesContext);
            }
        }
        DefaultFaceletContext ctx = new DefaultFaceletContext(facesContext, (AbstractFacelet)this, myFaceletContext);
        FaceletContext oldCtx = (FaceletContext)((Object)facesContext.getAttributes().put(FaceletContext.FACELET_CONTEXT_KEY, (Object)ctx));
        ctx.pushPageContext(new PageContextImpl());
        try {
            boolean pushedUniqueIdVendor = false;
            if (parent instanceof UniqueIdVendor && ctx.getFaceletCompositionContext().getUniqueIdVendorFromStack() == null) {
                ctx.getFaceletCompositionContext().pushUniqueIdVendorToStack((UniqueIdVendor)((Object)parent));
                pushedUniqueIdVendor = true;
            }
            this.refresh(parent);
            myFaceletContext.markForDeletion(parent);
            this._root.apply(ctx, parent);
            if (faceletCompositionContextInitialized && parent instanceof UIViewRoot) {
                UIComponent metadataFacet = parent.getFacet("jakarta_faces_metadata");
                if (metadataFacet != null) {
                    myFaceletContext.removeComponentForDeletion(metadataFacet);
                }
                if (myFaceletContext.isRefreshingTransientBuild()) {
                    myFaceletContext.finalizeRelocatableResourcesForDeletion((UIViewRoot)parent);
                }
            }
            myFaceletContext.finalizeForDeletion(parent);
            this.markApplied(parent);
            if (pushedUniqueIdVendor) {
                ctx.getFaceletCompositionContext().popUniqueIdVendorToStack();
            }
        }
        finally {
            ctx.popPageContext();
            if (faceletCompositionContextInitialized) {
                if (parent instanceof UIViewRoot) {
                    ComponentSupport.setCachedFacesContext((UIViewRoot)parent, null);
                }
                myFaceletContext.release(facesContext);
                List<String> uniqueIdList = ((EncodingHandler)this._root).getUniqueIdList();
                if (recordUniqueIds && uniqueIdList == null) {
                    uniqueIdList = Collections.unmodifiableList(myFaceletContext.getUniqueIdList());
                    ((EncodingHandler)this._root).setUniqueIdList(uniqueIdList);
                }
            }
            if (oldCtx != null) {
                facesContext.getAttributes().put(FaceletContext.FACELET_CONTEXT_KEY, (Object)oldCtx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyDynamicComponentHandler(FacesContext facesContext, UIComponent parent, String baseKey) throws IOException, FacesException, FaceletException, ELException {
        FaceletCompositionContext fcctx = null;
        boolean faceletCompositionContextInitialized = false;
        fcctx = FaceletCompositionContext.getCurrentInstance(facesContext);
        boolean pushDynCompSection = false;
        if (fcctx == null) {
            fcctx = new FaceletCompositionContextImpl(this._factory, facesContext, baseKey);
            fcctx.init(facesContext);
            faceletCompositionContextInitialized = true;
        } else {
            pushDynCompSection = true;
            fcctx.pushDynamicComponentSection(baseKey);
        }
        if (parent.getAttributes().containsKey("oam.vf.DYN_WRAPPER")) {
            fcctx.setDynamicComponentTopLevel(false);
        }
        FaceletContext oldCtx = (FaceletContext)((Object)facesContext.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY));
        DefaultFaceletContext ctx = new DefaultFaceletContext(facesContext, (AbstractFacelet)this, fcctx);
        facesContext.getAttributes().put(FaceletContext.FACELET_CONTEXT_KEY, (Object)ctx);
        ctx.pushPageContext(new PageContextImpl());
        try {
            boolean pushedUniqueIdVendor = false;
            if (parent instanceof UniqueIdVendor && ctx.getFaceletCompositionContext().getUniqueIdVendorFromStack() == null) {
                ctx.getFaceletCompositionContext().pushUniqueIdVendorToStack((UniqueIdVendor)((Object)parent));
                pushedUniqueIdVendor = true;
            }
            this._root.apply(ctx, parent);
            if (pushedUniqueIdVendor) {
                ctx.getFaceletCompositionContext().popUniqueIdVendorToStack();
            }
        }
        finally {
            ctx.popPageContext();
            facesContext.getAttributes().put(FaceletContext.FACELET_CONTEXT_KEY, (Object)oldCtx);
            if (pushDynCompSection) {
                fcctx.popDynamicComponentSection();
            }
            if (faceletCompositionContextInitialized) {
                fcctx.release(facesContext);
            }
        }
    }

    private void refresh(UIComponent c) {
        if (this._refreshPeriod > 0L) {
            ApplyToken token;
            int sz = c.getChildCount();
            if (sz > 0) {
                UIComponent cc = null;
                List<UIComponent> cl = c.getChildren();
                while (--sz >= 0) {
                    cc = cl.get(sz);
                    if (cc.isTransient() || (token = (ApplyToken)cc.getAttributes().get(APPLIED_KEY)) == null || token._time >= this._createTime || !token._alias.equals(this._alias)) continue;
                    if (log.isLoggable(Level.INFO)) {
                        DateFormat df = SimpleDateFormat.getTimeInstance();
                        log.info("Facelet[" + this._alias + "] was modified @ " + df.format(new Date(this._createTime)) + ", flushing component applied @ " + df.format(new Date(token._time)));
                    }
                    cl.remove(sz);
                }
            }
            if (c.getFacetCount() > 0) {
                Collection<UIComponent> col = c.getFacets().values();
                Iterator<UIComponent> itr = col.iterator();
                while (itr.hasNext()) {
                    UIComponent fc = itr.next();
                    if (fc.isTransient() || (token = (ApplyToken)fc.getAttributes().get(APPLIED_KEY)) == null || token._time >= this._createTime || !token._alias.equals(this._alias)) continue;
                    if (log.isLoggable(Level.INFO)) {
                        DateFormat df = SimpleDateFormat.getTimeInstance();
                        log.info("Facelet[" + this._alias + "] was modified @ " + df.format(new Date(this._createTime)) + ", flushing component applied @ " + df.format(new Date(token._time)));
                    }
                    itr.remove();
                }
            }
        }
    }

    private void markApplied(UIComponent parent) {
        if (this._refreshPeriod > 0L) {
            int facetCount = parent.getFacetCount();
            int childCount = parent.getChildCount();
            if (childCount > 0 || facetCount > 0) {
                ApplyToken token = new ApplyToken(this._alias, System.currentTimeMillis() + this._refreshPeriod);
                if (facetCount > 0) {
                    for (UIComponent facet : parent.getFacets().values()) {
                        this.markApplied(token, facet);
                    }
                }
                for (int i = 0; i < childCount; ++i) {
                    UIComponent child = parent.getChildren().get(i);
                    this.markApplied(token, child);
                }
            }
        }
    }

    private void markApplied(ApplyToken token, UIComponent c) {
        Map<String, Object> attr;
        if (!c.isTransient() && !(attr = c.getAttributes()).containsKey(APPLIED_KEY)) {
            attr.put(APPLIED_KEY, token);
        }
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public String getFaceletId() {
        return this._faceletId;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        return this._elFactory;
    }

    public long getCreateTime() {
        return this._createTime;
    }

    private URL getRelativePath(FacesContext facesContext, String path) throws IOException {
        ViewResource viewResource;
        URL url = this._relativePaths.get(path);
        if (url == null && (url = this._factory.resolveURL(facesContext, this._src, path)) != null && (viewResource = (ViewResource)facesContext.getAttributes().get("oam.facelets.LAST_RESOURCE_RESOLVED")) == null) {
            this._relativePaths.put(path, url);
        }
        return url;
    }

    public URL getSource() {
        return this._src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void include(AbstractFaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        ctx.pushPageContext(new PageContextImpl());
        try {
            this.refresh(parent);
            DefaultFaceletContext ctxWrapper = new DefaultFaceletContext((DefaultFaceletContext)ctx, (AbstractFacelet)this, false);
            ctx.getFacesContext().getAttributes().put(FaceletContext.FACELET_CONTEXT_KEY, (Object)ctxWrapper);
            this._root.apply(ctxWrapper, parent);
            ctx.getFacesContext().getAttributes().put(FaceletContext.FACELET_CONTEXT_KEY, (Object)ctx);
            this.markApplied(parent);
        }
        finally {
            ctx.popPageContext();
        }
    }

    @Override
    public void include(AbstractFaceletContext ctx, UIComponent parent, String path) throws IOException, FacesException, FaceletException, ELException {
        URL url = this.getRelativePath(ctx.getFacesContext(), path);
        this.include(ctx, parent, url);
    }

    @Override
    public void include(AbstractFaceletContext ctx, UIComponent parent, URL url) throws IOException, FacesException, FaceletException, ELException {
        DefaultFacelet f = (DefaultFacelet)this._factory.getFacelet(ctx, url);
        f.include(ctx, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyCompositeComponent(AbstractFaceletContext ctx, UIComponent parent, Resource resource) throws IOException, FacesException, FaceletException, ELException {
        DefaultFacelet f = (DefaultFacelet)this._factory.getFacelet(resource.getURL());
        ctx.pushPageContext(new PageContextImpl());
        try {
            boolean pushedUniqueIdVendor = false;
            FaceletCompositionContext mctx = ctx.getFaceletCompositionContext();
            if (parent instanceof UniqueIdVendor && ctx.getFaceletCompositionContext().getUniqueIdVendorFromStack() == null) {
                mctx.pushUniqueIdVendorToStack((UniqueIdVendor)((Object)parent));
                pushedUniqueIdVendor = true;
            }
            f.refresh(parent);
            mctx.markForDeletion(parent);
            DefaultFaceletContext ctxWrapper = new DefaultFaceletContext((DefaultFaceletContext)ctx, (AbstractFacelet)f, true);
            ctx.getFacesContext().getAttributes().put(FaceletContext.FACELET_CONTEXT_KEY, (Object)ctxWrapper);
            f._root.apply(ctxWrapper, parent);
            ctx.getFacesContext().getAttributes().put(FaceletContext.FACELET_CONTEXT_KEY, (Object)ctx);
            mctx.finalizeForDeletion(parent);
            f.markApplied(parent);
            if (pushedUniqueIdVendor) {
                ctx.getFaceletCompositionContext().popUniqueIdVendorToStack();
            }
        }
        finally {
            ctx.popPageContext();
        }
    }

    public String toString() {
        return this._alias;
    }

    @Override
    public boolean isBuildingCompositeComponentMetadata() {
        return this._isBuildingCompositeComponentMetadata;
    }

    private static class ApplyToken
    implements Externalizable {
        public String _alias;
        public long _time;

        public ApplyToken() {
        }

        public ApplyToken(String alias, long time) {
            this._alias = alias;
            this._time = time;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._alias = in.readUTF();
            this._time = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this._alias);
            out.writeLong(this._time);
        }
    }
}

