/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.convert;

import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.faces.component.StateHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.EvaluationException;
import jakarta.faces.el.MethodBinding;
import jakarta.faces.el.MethodNotFoundException;

public final class MethodExpressionToMethodBinding
extends MethodBinding
implements StateHolder {
    private MethodExpression methodExpression;
    private boolean isTransient = false;

    public MethodExpressionToMethodBinding() {
        this.methodExpression = null;
    }

    public MethodExpressionToMethodBinding(MethodExpression methodExpression) {
        this.methodExpression = methodExpression;
    }

    public String getExpressionString() {
        return this.methodExpression.getExpressionString();
    }

    public Class getType(FacesContext facesContext) throws MethodNotFoundException {
        try {
            return this.methodExpression.getMethodInfo(facesContext.getELContext()).getReturnType();
        }
        catch (jakarta.el.MethodNotFoundException e) {
            throw new MethodNotFoundException((Throwable)e);
        }
    }

    public Object invoke(FacesContext facesContext, Object[] params) throws EvaluationException, MethodNotFoundException {
        try {
            return this.methodExpression.invoke(facesContext.getELContext(), params);
        }
        catch (jakarta.el.MethodNotFoundException e) {
            throw new MethodNotFoundException((Throwable)e);
        }
        catch (ELException e) {
            throw new EvaluationException(e.getCause());
        }
    }

    public void restoreState(FacesContext context, Object state) {
        this.methodExpression = (MethodExpression)state;
    }

    public Object saveState(FacesContext context) {
        return this.methodExpression;
    }

    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    public boolean isTransient() {
        return this.isTransient;
    }
}

