/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import org.apache.myfaces.cdi.FacesScoped;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;

@Typed
public class FacesScopeContext
implements Context {
    public static final String FACES_SCOPE_MAP = "oam.FACES_SCOPE_MAP";
    private BeanManager beanManager;

    public FacesScopeContext(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    protected ContextualStorage getContextualStorage(boolean createIfNotExist, FacesContext facesContext) {
        if (facesContext == null) {
            throw new ContextNotActiveException(this.getClass().getName() + ": no current active facesContext");
        }
        ContextualStorage storage = (ContextualStorage)facesContext.getAttributes().get(FACES_SCOPE_MAP);
        if (storage == null && createIfNotExist) {
            storage = new ContextualStorage(this.beanManager, false);
            facesContext.getAttributes().put(FACES_SCOPE_MAP, storage);
        }
        return storage;
    }

    public Class<? extends Annotation> getScope() {
        return FacesScoped.class;
    }

    public boolean isActive() {
        return FacesContext.getCurrentInstance() != null;
    }

    public <T> T get(Contextual<T> bean) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        if (facesContext != null) {
            Map<Object, ContextualInstanceInfo<?>> contextMap;
            ContextualInstanceInfo<?> contextualInstanceInfo;
            ContextualStorage storage = this.getContextualStorage(false, facesContext);
            if (storage != null && (contextualInstanceInfo = (contextMap = storage.getStorage()).get(storage.getBeanKey(bean))) != null) {
                return (T)contextualInstanceInfo.getContextualInstance();
            }
        } else {
            throw new IllegalStateException("FacesContext cannot be found when resolving bean " + bean.toString());
        }
        return null;
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object instance;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        ContextualStorage storage = this.getContextualStorage(true, facesContext);
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo != null && (instance = contextualInstanceInfo.getContextualInstance()) != null) {
            return (T)instance;
        }
        return storage.createContextualInstance(bean, creationalContext);
    }

    public boolean destroy(Contextual bean) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ContextualStorage storage = this.getContextualStorage(false, facesContext);
        if (storage == null) {
            return false;
        }
        ContextualInstanceInfo<?> contextualInstanceInfo = storage.getStorage().get(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return false;
        }
        bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
        return true;
    }

    protected void checkActive(FacesContext facesContext) {
        if (facesContext == null) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }

    public static void destroyAllActive(FacesContext facesContext) {
        if (facesContext == null) {
            return;
        }
        ContextualStorage storage = (ContextualStorage)facesContext.getAttributes().remove(FACES_SCOPE_MAP);
        if (storage != null) {
            Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
            for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : contextMap.entrySet()) {
                Contextual<?> bean = storage.getBean(entry.getKey());
                ContextualInstanceInfo<?> contextualInstanceInfo = entry.getValue();
                bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
            }
        }
    }
}

