/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.context.ExceptionHandler;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.SystemEvent;
import org.apache.myfaces.util.lang.Assert;

public class ExceptionHandlerImpl
extends ExceptionHandler {
    private static final Logger log = Logger.getLogger(ExceptionHandlerImpl.class.getName());
    private Queue<ExceptionQueuedEvent> handled;
    private Queue<ExceptionQueuedEvent> unhandled;
    private ExceptionQueuedEvent handledAndThrown;

    @Override
    public ExceptionQueuedEvent getHandledExceptionQueuedEvent() {
        return this.handledAndThrown;
    }

    @Override
    public Iterable<ExceptionQueuedEvent> getHandledExceptionQueuedEvents() {
        return this.handled == null ? Collections.emptyList() : this.handled;
    }

    @Override
    public Throwable getRootCause(Throwable throwable) {
        Assert.notNull(throwable, "throwable");
        while (throwable != null) {
            Class<?> clazz = throwable.getClass();
            if (!clazz.equals(FacesException.class) && !clazz.equals(ELException.class)) {
                return throwable;
            }
            throwable = throwable.getCause();
        }
        return null;
    }

    @Override
    public Iterable<ExceptionQueuedEvent> getUnhandledExceptionQueuedEvents() {
        return this.unhandled == null ? Collections.emptyList() : this.unhandled;
    }

    @Override
    public void handle() throws FacesException {
        if (this.unhandled != null && !this.unhandled.isEmpty()) {
            if (this.handled == null) {
                this.handled = new LinkedList<ExceptionQueuedEvent>();
            }
            FacesException toThrow = null;
            do {
                ExceptionQueuedEvent event = this.unhandled.peek();
                try {
                    ExceptionQueuedEventContext context = event.getContext();
                    Throwable exception = context.getException();
                    if (!this.shouldSkip(exception)) {
                        this.handledAndThrown = event;
                        toThrow = this.wrap(this.getRethrownException(exception));
                        break;
                    }
                    log.log(Level.SEVERE, exception.getClass().getName() + " occured while processing " + (context.inBeforePhase() ? "beforePhase() of " : (context.inAfterPhase() ? "afterPhase() of " : "")) + "phase " + context.getPhaseId() + ": UIComponent-ClientId=" + (context.getComponent() != null ? context.getComponent().getClientId(context.getContext()) : "") + ", Message=" + exception.getMessage());
                    log.log(Level.SEVERE, exception.getMessage(), exception);
                }
                catch (Throwable t) {
                    throw new FacesException("Could not perform the algorithm to handle the Exception", t);
                }
                finally {
                    this.handled.add(event);
                    this.unhandled.remove(event);
                }
            } while (!this.unhandled.isEmpty());
            if (toThrow != null) {
                throw toThrow;
            }
        }
    }

    @Override
    public boolean isListenerForSource(Object source) {
        return source instanceof ExceptionQueuedEventContext;
    }

    @Override
    public void processEvent(SystemEvent exceptionQueuedEvent) throws AbortProcessingException {
        if (this.unhandled == null) {
            this.unhandled = new LinkedList<ExceptionQueuedEvent>();
        }
        this.unhandled.add((ExceptionQueuedEvent)exceptionQueuedEvent);
    }

    protected Throwable getRethrownException(Throwable exception) {
        Throwable toRethrow = this.getRootCause(exception);
        if (toRethrow == null) {
            toRethrow = exception;
        }
        return toRethrow;
    }

    protected FacesException wrap(Throwable exception) {
        if (exception instanceof FacesException) {
            return (FacesException)exception;
        }
        return new FacesException(exception);
    }

    protected boolean shouldSkip(Throwable exception) {
        return exception instanceof AbortProcessingException;
    }
}

